/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.neptunesetting;

import com.ericsson.cms.service.api.AbstractClient;
import com.ericsson.cms.service.api.ResponseEntity;
import com.ericsson.cms.service.api.exception.RequestException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NeptuneSettingClient
extends AbstractClient {
    private static Map<String, String> headerMap = new HashMap<String, String>();
    private ObjectMapper mapper = new ObjectMapper();

    public NeptuneSettingClient() {
        this.baseURL = "https://app:8443";
    }

    public Map<String, String> getSettings(String settingGroup) {
        String fullURL = StringUtils.join(Arrays.asList(this.baseURL, "cms/services/settings", settingGroup), (String)"/");
        ResponseEntity entity = this.sendHttpGetRequest(fullURL, headerMap);
        this.validateResponse(entity);
        return this.parseJson(entity.getBody());
    }

    public String getSetting(String settingGroup, String settingKey) {
        return this.getSettings(settingGroup).get(settingKey);
    }

    private Map<String, String> parseJson(String jsonStr) {
        try {
            return (Map)this.mapper.readValue(jsonStr, HashMap.class);
        }
        catch (Exception e) {
            throw new RequestException("fail to parse the response json : " + jsonStr, e);
        }
    }

    static {
        headerMap.put("Content-Type", "application/json");
        headerMap.put("Accept", "application/json");
    }

    public static class NeptuneSettingClientBuilder
    extends AbstractClient.AbstractClientBuilder<NeptuneSettingClientBuilder, NeptuneSettingClient> {
        @Override
        public NeptuneSettingClient build() {
            NeptuneSettingClient client = new NeptuneSettingClient();
            client.setAccessToken(this.accessToken);
            if (StringUtils.isNotEmpty((String)this.baseURL)) {
                client.setBaseURL(this.baseURL);
            }
            client.setUserName(this.userName);
            client.setPassword(this.password);
            client.setSocketTimeOut(this.socketTimeOut);
            client.setConnectionTimeOut(this.connectionTimeOut);
            client.setConnectionRequestTimeOut(this.connectionRequestTimeOut);
            return client;
        }
    }
}

