/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.util;

import com.ericsson.cms.service.api.exception.RequestException;
import com.ericsson.cms.service.api.util.DeviceTemplateProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ApiUtil {
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String PUT_METHOD = "PUT";
    public static final String DEFAULT_APP_URL = "https://app:8443";
    public static final String DEFAULT_CT_URL = "https://app:8444";
    public static final String DEFAULT_EXTERNAL_APP_URL = "https://watchpoint-app:8443";
    public static final String PATH_DELEMITER = "/";
    public static final String ACCESS_TOKEN_NAME = "access_token";
    public static final String SETTINGS_PATH = "cms/services/settings";
    public static final String DEVICE_PATH = "cms/resource/services";
    public static final String FM_MESSAGE_PATH = "filemanager/services/FileSubsystemWebservice";
    public static final String IM_MESSAGE_PATH = "imagemagick/services/ImageMagickWebService";
    public static final String FFMPEG_MESSAGE_PATH = "ffmpeg/services/FfmpegWebservice";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String XML_MIME_TYPE = "application/xml";
    public static final String ACCEPT = "Accept";
    public static final String PARAMETER_TEMPLATE = "<Parameter DataType=\"String\" Name=\"{name}\"><Value>{value}</Value></Parameter>";
    private static final String SOAPENV_PREFIX = "soapenv";
    private static final String SOAPENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String XSD_PREFIX = "xsd";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String VALUE_NODE_NAME = "Value";
    private static final Map<String, String> PREFIX_MAP = new HashMap<String, String>();
    private static ThreadLocal<DocumentBuilder> docBuilderHolder = new ThreadLocal();
    private static ThreadLocal<XPath> xpathHolder = new ThreadLocal();
    private static final String PARAMETER_XPATH = "/soapenv:Envelope/soapenv:Body/WFSMessage/MessageBody/ParameterList/Parameter";
    private static final String TYPE_XPATH = "/soapenv:Envelope/soapenv:Body/WFSMessage/@Type";
    public static final String DEVICE_TEMPLATE = ApiUtil.getTemplate();
    public static final String UID_PLACE_HOLDER = "\\{UID\\}";
    public static final String PARAMETERS_PLACE_HOLDER = "\\{parameters\\}";
    public static final String ACK_TYPE = "ackType";

    private ApiUtil() {
    }

    public static String getTemplate() {
        return DeviceTemplateProvider.getDeviceTemplateContent();
    }

    public static String getDeviceRequestPayload(String uID, Map<String, String> parameters) {
        return ApiUtil.getWPCLRequestPayload(DEVICE_TEMPLATE, uID, parameters);
    }

    public static String getWPCLRequestPayload(String template, String uID, Map<String, String> parameters) {
        ArrayList<String> paramList = new ArrayList<String>();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                paramList.add(PARAMETER_TEMPLATE.replaceFirst("\\{name\\}", entry.getKey()).replaceFirst("\\{value\\}", Matcher.quoteReplacement(entry.getValue())));
            }
        }
        String params = StringUtils.join(paramList, (String)System.lineSeparator());
        return template.replaceFirst(UID_PLACE_HOLDER, uID).replaceFirst(PARAMETERS_PLACE_HOLDER, Matcher.quoteReplacement(params));
    }

    public static Map<String, String> parseWPCLResponse(String body) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            Document doc = ApiUtil.getDocumentBuilder().parse(IOUtils.toInputStream((String)body, (String)"utf-8"));
            NodeList paramsList = (NodeList)ApiUtil.getXpath().compile(PARAMETER_XPATH).evaluate(doc, XPathConstants.NODESET);
            ApiUtil.fillParamToMap(paramsList, results);
            String type = (String)ApiUtil.getXpath().compile(TYPE_XPATH).evaluate(doc, XPathConstants.STRING);
            results.put(ACK_TYPE, type);
        }
        catch (Exception e) {
            throw new RequestException(" fail to parse the response body " + body, e);
        }
        return results;
    }

    private static void fillParamToMap(NodeList paramsList, Map<String, String> results) {
        for (int i = 0; i < paramsList.getLength(); ++i) {
            if ("List".equals(paramsList.item(i).getAttributes().getNamedItem("DataType").getNodeValue())) {
                ApiUtil.fillParamToMap(paramsList.item(i).getChildNodes(), results);
                continue;
            }
            results.put(paramsList.item(i).getAttributes().getNamedItem("Name").getNodeValue(), ApiUtil.getParamValue(paramsList.item(i).getChildNodes()));
        }
    }

    private static String getParamValue(NodeList childNodes) {
        if (childNodes == null || childNodes.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals(VALUE_NODE_NAME)) continue;
            return childNodes.item(i).getTextContent();
        }
        return null;
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder docBuilder = docBuilderHolder.get();
        if (docBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            docBuilder = documentBuilderFactory.newDocumentBuilder();
            docBuilderHolder.set(docBuilder);
        }
        docBuilder.reset();
        return docBuilder;
    }

    private static XPath getXpath() throws XPathFactoryConfigurationException {
        XPath xpath = xpathHolder.get();
        if (xpath == null) {
            xpath = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", ClassLoader.getSystemClassLoader()).newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    String namespace = (String)PREFIX_MAP.get(prefix);
                    return namespace != null ? namespace : "";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public Iterator<?> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            xpathHolder.set(xpath);
        }
        xpath.reset();
        return xpath;
    }

    static {
        PREFIX_MAP.put(SOAPENV_PREFIX, SOAPENV_NAMESPACE);
        PREFIX_MAP.put(XSD_PREFIX, XSD_NAMESPACE);
        PREFIX_MAP.put(XSI_PREFIX, XSI_NAMESPACE);
    }
}

