/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.service.api.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.io.IOUtils;

public class SSLUtil {
    private static final String SECURITY_DIR = "/var/lib/nobody";
    public static final String KEYSTORE_FILE = "/var/lib/nobody/client_auth_keystore.jks";
    public static final String TRUSTSTORE_FILE = "/var/lib/nobody/cms_truststore.jks";
    private static final String KEYSTORE_PASSWORD_FILE = "/var/lib/nobody/keystore.pass";
    private static final String STORE_FORMAT_JKS = "JKS";

    private SSLUtil() {
    }

    public static KeyStore getKeyStore(String file) throws NoSuchAlgorithmException, CertificateException, Exception {
        try (FileInputStream keyStoreStream = new FileInputStream(file);){
            KeyStore keyStore = KeyStore.getInstance(STORE_FORMAT_JKS);
            keyStore.load(keyStoreStream, SSLUtil.getStorePassword().toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static String getStorePassword() throws FileNotFoundException, IOException {
        return (String)IOUtils.readLines((InputStream)new FileInputStream(KEYSTORE_PASSWORD_FILE)).get(0);
    }
}

