/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionFailureInfo;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.DistributionStatusDetail;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DistributionSiteTitle
implements Serializable {
    private static final Logger logger = Logger.getLogger(DistributionSiteTitle.class);
    private static final long serialVersionUID = 1L;
    private Long id;
    private Title title;
    private DistributionSite distributionSite;
    private DistributionStatus status;
    private Date statusUpdatedTime;
    private String distributedVersion;
    private int statusDetail;
    private String failureReason;

    public DistributionSiteTitle() {
    }

    public DistributionSiteTitle(DistributionSite distSite, Title title, DistributionStatus status) {
        this.setDistributionSite(distSite);
        this.setTitle(title);
        this.setStatus(status);
    }

    public DistributionSiteTitle(DistributionSite distSite, Title title, String failureReason) {
        this(distSite, title, DistributionStatus.FAILED);
        this.setFailureReason(failureReason);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public DistributionSite getDistributionSite() {
        return this.distributionSite;
    }

    public void setDistributionSite(DistributionSite distributionSite) {
        this.distributionSite = distributionSite;
    }

    public DistributionStatus getStatus() {
        return this.status;
    }

    public void setStatus(DistributionStatus status) {
        this.status = status;
        if (status != DistributionStatus.FAILED) {
            this.clearFailureInfo();
        }
        this.setStatusUpdatedTime(new Date());
    }

    public Date getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    private void setStatusUpdatedTime(Date statusUpdatedTime) {
        this.statusUpdatedTime = statusUpdatedTime;
    }

    public String getDistributedVersion() {
        return this.distributedVersion;
    }

    public void setDistributedVersion(String distributedVersion) {
        this.distributedVersion = distributedVersion;
    }

    public boolean isChangedAfterDistribution() {
        String version = this.getTitle() != null ? this.getTitle().getVersion() : null;
        return this.getDistributedVersion() != null && !this.getDistributedVersion().equals(version);
    }

    public int getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(int statusDetail) {
        this.statusDetail = statusDetail;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public void clearFailureInfo() {
        this.statusDetail = DistributionStatusDetail.NONE.ordinal();
        this.failureReason = null;
    }

    public void updateDistributionFailureInfo(DistributionFailureInfo failureInfo) {
        this.statusDetail = failureInfo.getFailureDetail().ordinal();
        this.failureReason = failureInfo.getFailureReason();
    }

    public boolean isDistributionStatusChanged(DistributionStatus newStatus, DistributionFailureInfo failureInfo) {
        int newDetail = failureInfo.getFailureDetail().ordinal();
        String newFailureReason = failureInfo.getFailureReason();
        String msg = String.format("checking status changed: %s -> %s, %d -> %d, '%s' -> '%s'", new Object[]{this.status, newStatus, this.statusDetail, newDetail, this.failureReason, newFailureReason});
        logger.debug((Object)msg);
        if (this.status == DistributionStatus.FAILED) {
            boolean statusChanged = newStatus != DistributionStatus.FAILED;
            boolean detailChanged = this.statusDetail != newDetail;
            boolean failureReasonChanged = !StringUtils.equals((String)this.failureReason, (String)newFailureReason);
            return statusChanged || detailChanged || failureReasonChanged;
        }
        return this.status != newStatus;
    }

    public int hashCode() {
        return 31 + (this.id == null ? super.hashCode() : this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DistributionSiteTitle)) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        return this.id.equals(((DistributionSiteTitle)obj).id);
    }

    public String toString() {
        return this.distributionSite.getId() + " | " + this.title.getId() + " | " + (Object)((Object)this.status);
    }
}

