/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

public enum DistributionStatus {
    TARGETED,
    READY_FOR_DISTRIBUTION,
    IN_PROGRESS,
    DISTRIBUTED,
    FAILED,
    WAITING_FOR_DEPENDENCY;

    private static final DistributionStatus[] STATUSES_ALLOW_DIRECT_UPDATE;
    private static final DistributionStatus[] STATUSES_IGNORED_FOR_DIRECT_UPDATE;
    private static final DistributionStatus[] STATUSES_ALLOW_DIRECT_UPDATE_TO_IN_PROGRESS;
    private static final DistributionStatus[] STATUSES_ALLOW_DISTRIBUTE_REQUEST;

    public boolean isWaitingForDependency() {
        return this.equals((Object)WAITING_FOR_DEPENDENCY);
    }

    public boolean allowDirectUpdate() {
        return this.containedInArray(STATUSES_ALLOW_DIRECT_UPDATE);
    }

    public boolean shouldIgnoreDirectUpdate() {
        return this.containedInArray(STATUSES_IGNORED_FOR_DIRECT_UPDATE);
    }

    public boolean allowDirectUpdateToInProgress() {
        return this.containedInArray(STATUSES_ALLOW_DIRECT_UPDATE_TO_IN_PROGRESS);
    }

    public boolean allowDistributeRequest() {
        return this.containedInArray(STATUSES_ALLOW_DISTRIBUTE_REQUEST);
    }

    public static String[] getStatusesAllowDirectUpdate() {
        return DistributionStatus.getStringsFromDistributionStatuses(STATUSES_ALLOW_DIRECT_UPDATE);
    }

    public static String[] getStatusesAllowDirectUpdateToInProgress() {
        return DistributionStatus.getStringsFromDistributionStatuses(STATUSES_ALLOW_DIRECT_UPDATE_TO_IN_PROGRESS);
    }

    public static String[] getStatusesAllowDistributionRequest() {
        return DistributionStatus.getStringsFromDistributionStatuses(STATUSES_ALLOW_DISTRIBUTE_REQUEST);
    }

    private boolean containedInArray(DistributionStatus[] statuses) {
        for (DistributionStatus status : statuses) {
            if (!this.equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    private static String[] getStringsFromDistributionStatuses(DistributionStatus[] statuses) {
        String[] statusStrings = new String[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            statusStrings[i] = statuses[i].name();
        }
        return statusStrings;
    }

    static {
        STATUSES_ALLOW_DIRECT_UPDATE = new DistributionStatus[]{FAILED, IN_PROGRESS, DISTRIBUTED};
        STATUSES_IGNORED_FOR_DIRECT_UPDATE = new DistributionStatus[]{TARGETED, READY_FOR_DISTRIBUTION};
        STATUSES_ALLOW_DIRECT_UPDATE_TO_IN_PROGRESS = new DistributionStatus[]{FAILED};
        STATUSES_ALLOW_DISTRIBUTE_REQUEST = new DistributionStatus[]{TARGETED, WAITING_FOR_DEPENDENCY};
    }
}

