/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.title.basicsearch;

import com.tandbergtv.cms.title.basicsearch.BasicSearchFieldValidator;
import com.tandbergtv.cms.title.basicsearch.InvalidBasicSearchPathException;
import com.tandbergtv.cms.title.search.entities.BasicSearchField;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.watchpoint.conf.SearchFieldProviderBase;
import com.tandbergtv.watchpoint.pmm.util.ExternalLocalizedMessageResolver;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class BasicSearchFieldProvider
extends SearchFieldProviderBase {
    public static final String SEARCH_FLD_DEF_FILE = "searchFields.xml";
    public static final String SERIES_SEARCH_FLD_DEF_FILE = "seriesSearchFields.xml";
    public static final String IN_PLACE_SEARCH_FLD_DEF_FILE = "inPlaceSearchFields.xml";
    public static final String BSEARCH_FILE_PATH = BSEARCH_FILE_DIRECTORY + File.separator + "searchFields.xml";
    public static final String BSEARCH_FILE_PATH_SERIES = BSEARCH_FILE_DIRECTORY + File.separator + "seriesSearchFields.xml";
    public static final String IN_PLACE_SEARCH_FILE_PATH = BSEARCH_FILE_DIRECTORY + File.separator + "inPlaceSearchFields.xml";
    private static final String RESOURCE_BUNDLE_BASE_NAME = "SearchFieldNames";
    private static final String IN_PLACE_SEARCH_RESOURCE_BUNDLE_BASE_NAME = "InPlaceSearchFieldNames";
    private static final String SERIES_RESOURCE_BUNDLE_BASE_NAME = "SeriesSearchFieldNames";
    private static final ThreadLocal<DocumentBuilder> DOCUMENT_BUILDER;
    private static BasicSearchFieldProvider instance;
    private static final Logger logger;

    public static synchronized BasicSearchFieldProvider getInstance() {
        if (instance == null) {
            instance = new BasicSearchFieldProvider();
        }
        return instance;
    }

    public List<BasicSearchField> getSearchFieldBase(CriteriaMode criteriaMode, Boolean inPlace) throws InvalidBasicSearchPathException {
        File searchFieldsFile;
        String bundleBaseName;
        String fldDefFile;
        String installFolder = System.getProperty("com.tandbergtv.cms.product.dir");
        if (criteriaMode.equals((Object)CriteriaMode.MASTER)) {
            if (inPlace.booleanValue()) {
                fldDefFile = IN_PLACE_SEARCH_FLD_DEF_FILE;
                bundleBaseName = IN_PLACE_SEARCH_RESOURCE_BUNDLE_BASE_NAME;
                searchFieldsFile = new File(installFolder + File.separator + IN_PLACE_SEARCH_FILE_PATH);
            } else {
                fldDefFile = SEARCH_FLD_DEF_FILE;
                bundleBaseName = RESOURCE_BUNDLE_BASE_NAME;
                searchFieldsFile = new File(installFolder + File.separator + BSEARCH_FILE_PATH);
            }
        } else {
            fldDefFile = SERIES_SEARCH_FLD_DEF_FILE;
            bundleBaseName = SERIES_RESOURCE_BUNDLE_BASE_NAME;
            searchFieldsFile = new File(installFolder + File.separator + BSEARCH_FILE_PATH_SERIES);
        }
        ArrayList<BasicSearchField> searchFields = new ArrayList<BasicSearchField>();
        try {
            Document doc;
            DocumentBuilder builder = DOCUMENT_BUILDER.get();
            builder.reset();
            boolean tryExternalResourceBundle = false;
            if (searchFieldsFile.exists()) {
                doc = builder.parse(searchFieldsFile);
                tryExternalResourceBundle = true;
            } else {
                URL fileUrl = BasicSearchFieldProvider.class.getResource(fldDefFile);
                InputStream is = fileUrl.openStream();
                doc = builder.parse(is);
            }
            ExternalLocalizedMessageResolver messageResolver = new ExternalLocalizedMessageResolver("content", tryExternalResourceBundle, CONTENT_MGMT_CONFIG_DIR_FULL_PATH, bundleBaseName);
            StringBuilder invalidXpathStringBuilder = new StringBuilder(100);
            this.processDocument(doc, messageResolver, (assetType, xpath, displayName, isMultiValue) -> {
                BasicSearchField basicField = new BasicSearchField(assetType, xpath, displayName);
                boolean validField = BasicSearchFieldValidator.validateBasicField(basicField, criteriaMode);
                if (validField) {
                    searchFields.add(basicField);
                } else if (!invalidXpathStringBuilder.toString().isEmpty()) {
                    invalidXpathStringBuilder.append(" , " + basicField.getXpath());
                } else {
                    invalidXpathStringBuilder.append(" " + basicField.getXpath());
                }
            });
            if (!invalidXpathStringBuilder.toString().isEmpty()) {
                throw new InvalidBasicSearchPathException("Invalid xpath: " + invalidXpathStringBuilder.toString());
            }
        }
        catch (InvalidBasicSearchPathException e) {
            logger.error((Object)"InvalidBasicSearchPathException.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error while looking up basic search fields.", (Throwable)e);
            return new ArrayList<BasicSearchField>();
        }
        return searchFields;
    }

    static {
        logger = Logger.getLogger(BasicSearchFieldProvider.class);
        URL schemaUrl = BasicSearchFieldProvider.class.getResource("basicsearch.xsd");
        DOCUMENT_BUILDER = BasicSearchFieldProvider.getThreadLocalDocumentBuilder((URL)schemaUrl);
    }
}

