/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.entities;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import java.io.Serializable;
import java.util.Collection;

public class ContentClass
implements Serializable {
    private static final long serialVersionUID = 5120808560122132399L;
    private long id;
    private String name;
    private String description;
    private Type type;
    private SpecialUsage specialUsage = SpecialUsage.None;
    private boolean isDefault;
    private ContentClassMetadata metadata;

    public ContentClass() {
        this.type = Type.Package;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public SpecialUsage getSpecialUsage() {
        return this.specialUsage;
    }

    public void setSpecialUsage(SpecialUsage specialUsage) {
        this.specialUsage = specialUsage;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ContentClassMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ContentClassMetadata metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return "[id=" + this.id + ", type = " + (Object)((Object)this.type) + ", name=" + this.name + ", description=" + this.description + ", isDefault=" + this.isDefault + ", specialUsage=" + (Object)((Object)this.specialUsage) + ", metadata=" + this.metadata + "]";
    }

    public ContentClass createCopy() {
        Collection<ContentClassAsset> ccAssets;
        ContentClass cc = this.createCopyWithoutMetadata();
        ContentClassMetadata metadataCopy = new ContentClassMetadata();
        if (this.metadata != null && (ccAssets = this.metadata.getAssetList()) != null) {
            ccAssets.forEach(ccAsset -> metadataCopy.addAsset(ccAsset.createCopy()));
        }
        cc.setMetadata(metadataCopy);
        return cc;
    }

    public ContentClass createCopyWithoutMetadata() {
        ContentClass cc = new ContentClass();
        cc.setId(this.id);
        cc.setName(this.name);
        cc.setDescription(this.description);
        cc.setType(this.type);
        cc.setSpecialUsage(this.specialUsage);
        cc.setDefault(this.isDefault);
        return cc;
    }

    public static enum Type {
        Package,
        Series,
        Category,
        Offer;

    }

    public static enum SpecialUsage {
        None,
        PreRoll,
        PostRoll;

    }
}

