/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.image;

import com.tandbergtv.content.image.IThumbnailGenerator;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class ThumbnailGeneratorFactory {
    private int preferredHeight;
    private int preferredWidth;
    private String thumbnailFormat;

    protected ThumbnailGeneratorFactory() {
    }

    public static ThumbnailGeneratorFactory getInstance() {
        ServiceLoader<ThumbnailGeneratorFactory> serviceLoader = ServiceLoader.load(ThumbnailGeneratorFactory.class);
        Iterator<ThumbnailGeneratorFactory> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("No " + ThumbnailGeneratorFactory.class.getName() + " implementation has been registered.");
        }
        ThumbnailGeneratorFactory instance = iterator.next();
        return instance;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public String getThumbnailFormat() {
        return this.thumbnailFormat;
    }

    public void setThumbnailFormat(String thumbnailFormat) {
        this.thumbnailFormat = thumbnailFormat;
    }

    public abstract IThumbnailGenerator createThumbnailGenerator();
}

