/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.conf;

import com.tandbergtv.watchpoint.pmm.util.ExternalLocalizedMessageResolver;
import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class SearchFieldProviderBase {
    protected static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    protected static final String BSEARCH_FILE_DIRECTORY = "conf" + File.separator + "contentMgmt";
    protected static final String CONTENT_MGMT_CONFIG_DIR_FULL_PATH = System.getProperty("com.tandbergtv.cms.product.dir") + File.separator + BSEARCH_FILE_DIRECTORY;

    protected static ThreadLocal<DocumentBuilder> getThreadLocalDocumentBuilder(final URL schemaUrl) {
        return new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
                    DocumentBuilderFactory dbmFactory = DocumentBuilderFactory.newInstance();
                    dbmFactory.setSchema(schema);
                    return dbmFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected void processDocument(Document doc, ExternalLocalizedMessageResolver messageResolver, ProcessSerachFieldNode processSerachFieldNode) throws Exception {
        NodeList nodes = doc.getElementsByTagName("mdmsearchfield");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String assetType = e.getAttribute("assetType");
            String xpath = e.getAttribute("xpath");
            String displayNameKey = e.getAttribute("displayName");
            String displayName = messageResolver.getI18nString(displayNameKey);
            String isMultiValue = e.getAttribute("isMultiValued");
            processSerachFieldNode.process(assetType, xpath, displayName, isMultiValue);
        }
    }

    @FunctionalInterface
    public static interface ProcessSerachFieldNode {
        public void process(String var1, String var2, String var3, String var4) throws Exception;
    }
}

