/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import java.util.List;

public class TitleValidationException
extends Exception {
    private static final long serialVersionUID = 6522855923899413857L;
    private static final String TITLE_HISTORY_DESCRIPTION_VALIDATEION_FAILED_1 = "The validation messages:";
    private static final String TITLE_HISTORY_DESCRIPTION_VALIDATEION_FAILED_2 = "The title failed validation with the following messages:";
    private List<TitleValidationMessage> messages;

    public TitleValidationException(List<TitleValidationMessage> messages) {
        this(null, messages);
    }

    protected TitleValidationException(String errorMessage, List<TitleValidationMessage> messages) {
        super(errorMessage);
        this.setMessages(messages);
    }

    public void addMessage(TitleValidationMessage message) {
        this.messages.add(message);
    }

    public List<TitleValidationMessage> getMessages() {
        return this.messages;
    }

    private void setMessages(List<TitleValidationMessage> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("messages list cannot be null");
        }
        this.messages = messages;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        String message = super.getMessage();
        if (message != null) {
            buf.append(message);
            buf.append(TITLE_HISTORY_DESCRIPTION_VALIDATEION_FAILED_1);
        } else {
            buf.append(TITLE_HISTORY_DESCRIPTION_VALIDATEION_FAILED_2);
        }
        String lineSeparator = System.getProperty("line.separator");
        buf.append(lineSeparator);
        for (TitleValidationMessage validationMessage : this.messages) {
            buf.append(String.format("%s:%s", validationMessage.getType().name(), validationMessage.getMessage())).append(lineSeparator);
        }
        return buf.toString();
    }
}

