/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.assetlist.AssetListErrorCode;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListRuntimeException;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEventType;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AssetList
implements IAssetList {
    private static final long serialVersionUID = -4868409973091400554L;
    protected Long id;
    protected String name;
    protected String description;
    protected Collection<Title> titles = new ArrayList<Title>();
    protected Collection<ProgressItem> progressItems = new ArrayList<ProgressItem>();
    protected Boolean isActive = true;

    protected AssetList() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    protected void addTitleInternal(Title title) {
        if (!title.getIsActive().booleanValue()) {
            String message = "Title[" + title.getId() + "] is inactive";
            throw new AssetListRuntimeException(message, AssetListErrorCode.INACTIVE_TITLE);
        }
        if (!this.titles.contains(title)) {
            this.titles.add(title);
        }
    }

    public void addTitle(Title title) {
        this.addTitleInternal(title);
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    public void addTitles(Title ... titles) {
        for (Title title : titles) {
            this.addTitleInternal(title);
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    public void addTitles(Collection<Title> titles) {
        for (Title title : titles) {
            this.addTitleInternal(title);
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    public Collection<ProgressItem> getProgressItems(Title title) {
        ArrayList<ProgressItem> items = new ArrayList<ProgressItem>();
        for (ProgressItem progress : this.progressItems) {
            if (!progress.getTitleId().equals(title.getId())) continue;
            items.add(progress);
        }
        return items;
    }

    protected void removeTitleInternal(Title title) {
        this.titles.remove(title);
        for (ProgressItem progress : this.getProgressItems(title)) {
            progress.setIsActive(false);
        }
    }

    public void removeTitle(Title title) {
        this.removeTitleInternal(title);
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
    }

    public void removeTitles(Collection<Title> titles) {
        for (Title title : titles) {
            this.removeTitleInternal(title);
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
    }

    public void removeTitles() {
        while (!this.titles.isEmpty()) {
            this.removeTitleInternal(this.titles.iterator().next());
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
    }

    public Title getTitle(Long titleId) {
        for (Title t : this.titles) {
            if (!t.getId().equals(titleId)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Collection<Title> getTitles() {
        return this.titles;
    }

    public void loadProgressItemsForTitles() {
        this.titles.forEach(title -> title.getProgressItems());
    }

    public void setTitles(Collection<Title> titles) {
        this.removeTitles();
        this.addTitles(titles);
    }

    public Collection<Title> getDelta(AssetList list) {
        HashSet<Title> delta = new HashSet<Title>();
        for (Title title : this.titles) {
            if (list.getTitles().contains(title)) continue;
            delta.add(title);
        }
        return delta;
    }

    protected void fireEvent(AssetListEvent event) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
    }

    public String toString() {
        String s = "[" + this.id + "]";
        if (this.titles != null) {
            s = s + " " + this.titles.size() + " titles";
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetList)) {
            return false;
        }
        AssetList other = (AssetList)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void reOrderTitles(List<Title> titles) {
        this.titles.clear();
        for (Title t : titles) {
            this.titles.add(t);
        }
    }
}

