/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContext;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Partner
implements Serializable,
IContainer {
    private static final long serialVersionUID = 3543030394003557805L;
    public static int MIN_AFFILIATION_CODE_LEN = 5;
    private static String PARTNER_NAME = "Name";
    private static String PARTNER_ID = "Id";
    private static String PARTNER_TYPE = "Type";
    private static String PARTNER_PROVIDERID = "ProviderId";
    private static String PARTNER_CONTEXT_ID = "ContextId";
    private static String PARTNER_EMAIL_ID = "EmailId";
    private static String PARTNER_AFFILIATION_CODE = "AffiliationCode";
    private long id;
    private String name;
    private PartnerType type;
    private String providerId;
    private Context context;
    private PartnerContact contact;
    private String notes;
    private Boolean isActive;
    private Boolean isTenant;
    private Boolean isEmailNotify = false;
    private Boolean isSuccessNotify = false;
    private String lookupKey;
    private byte[] thumbnail;
    private List<Partner> childPartnerList = null;
    private String affiliationCode = "00000";

    public Partner() {
        this.context = new PartnerContext();
        ((PartnerContext)this.context).setContainer(this);
    }

    public Partner(long partnerId) {
        this.id = partnerId;
    }

    public Partner(long id, String name, PartnerType type, String providerId, long contextId, String lookupKey) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.providerId = providerId;
        this.context = new Context();
        this.context.setId(contextId);
        this.lookupKey = lookupKey;
        this.isActive = true;
        this.isTenant = false;
        this.isEmailNotify = false;
    }

    public Partner(long id, String name, PartnerType type, String providerId, long contextId, String lookupKey, Boolean isTenant) {
        this(id, name, type, providerId, contextId, lookupKey);
        this.isTenant = isTenant;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(PartnerType type) {
        this.type = type;
    }

    public PartnerType getType() {
        return this.type;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public String getContainerName() {
        return this.getName();
    }

    @Override
    public long getContainerContextId() {
        return this.getContext().getId();
    }

    @Override
    public long getContainerId() {
        return this.id;
    }

    @Override
    public String getContainerLookupKey() {
        return this.lookupKey;
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.PARTNER;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public PartnerContact getContact() {
        return this.contact;
    }

    public void setContact(PartnerContact contact) {
        this.contact = contact;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsTenant() {
        return this.isTenant;
    }

    public Boolean getIsEmailNotify() {
        return this.isEmailNotify;
    }

    public void setIsEmailNotify(Boolean isEmailNotify) {
        this.isEmailNotify = isEmailNotify;
    }

    public Boolean getIsSuccessNotify() {
        return this.isSuccessNotify;
    }

    public void setIsSuccessNotify(Boolean isSuccessNotify) {
        this.isSuccessNotify = isSuccessNotify;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public void setIsTenant(Boolean isTenant) {
        this.isTenant = isTenant;
    }

    public String getLookupKey() {
        return this.lookupKey;
    }

    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Partner other = (Partner)obj;
        return this.id == other.id;
    }

    @Override
    public String getValue(String propertyName) {
        if (propertyName.equalsIgnoreCase(PARTNER_CONTEXT_ID)) {
            return String.valueOf(this.context.getId());
        }
        if (propertyName.equalsIgnoreCase(PARTNER_EMAIL_ID)) {
            return this.contact.getEmail();
        }
        if (propertyName.equalsIgnoreCase(PARTNER_ID)) {
            return String.valueOf(this.id);
        }
        if (propertyName.equalsIgnoreCase(PARTNER_NAME)) {
            return this.name;
        }
        if (propertyName.equalsIgnoreCase(PARTNER_PROVIDERID)) {
            return this.providerId;
        }
        if (propertyName.equalsIgnoreCase(PARTNER_TYPE)) {
            return this.getType().toString();
        }
        if (propertyName.equalsIgnoreCase(PARTNER_AFFILIATION_CODE)) {
            return this.affiliationCode;
        }
        return new String();
    }

    @Override
    public List<ContainerProperty> getProperties() {
        return this.getContext().getProperties();
    }

    @Override
    public void setProperties(List<ContainerProperty> properties) {
        this.getContext().setProperties(properties);
    }

    public void updateProperties(List<ContainerProperty> properties) {
        this.getContext().updateProperties(properties);
    }

    @Override
    public void addProperty(String name, String value) {
        this.getContext().addProperty(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.getContext().removeProperty(name);
    }

    @Override
    public void removeAllProperties() {
        this.context.getProperties().clear();
    }

    public byte[] getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getAffiliationCode() {
        return this.affiliationCode;
    }

    public void setAffiliationCode(String affiliationCode) {
        this.affiliationCode = affiliationCode;
    }

    public List<Partner> getChildPartnerList() {
        return this.childPartnerList;
    }

    public void setChildPartnerList(List<Partner> childPartnerList) {
        this.childPartnerList = childPartnerList;
    }

    public void addChildPartnerList(Partner partner) {
        if (this.childPartnerList != null) {
            this.childPartnerList.add(partner);
        } else {
            this.childPartnerList = new ArrayList<Partner>(1);
            this.childPartnerList.add(partner);
        }
    }

    public String createAffiliationCode() {
        String formatStr = "%0" + MIN_AFFILIATION_CODE_LEN + "d";
        return String.format(formatStr, this.id);
    }

    public boolean isTopLevelPartner() {
        return this.affiliationCode == null || this.affiliationCode.length() == MIN_AFFILIATION_CODE_LEN;
    }

    public String toString() {
        return "Partner [id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", providerId=" + this.providerId + ", isActive=" + this.isActive + "]";
    }
}

