/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities.activity;

import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum TitleActivityType {
    ACTIVE(ProcessStatus.CREATED, ProcessStatus.RUNNING, ProcessStatus.PAUSED, ProcessStatus.QUEUED, ProcessStatus.BUSY, ProcessStatus.BRANCHED),
    HISTORICAL(ProcessStatus.ERROR, ProcessStatus.CANCELLED, ProcessStatus.COMPLETED, ProcessStatus.ARCHIVED);

    private EnumSet<ProcessStatus> processStatusSet;

    private TitleActivityType(ProcessStatus ... status) {
        this.processStatusSet = EnumSet.copyOf(Arrays.asList(status));
    }

    public Set<ProcessStatus> getAllCoveredProcessStatus() {
        return this.processStatusSet;
    }

    public boolean covers(ProcessStatus status) {
        return this.processStatusSet.contains(status);
    }

    public static TitleActivityType mapStatusToActivityType(ProcessStatus status) {
        for (TitleActivityType actType : TitleActivityType.values()) {
            if (!actType.covers(status)) continue;
            return actType;
        }
        return ACTIVE;
    }
}

