/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.LocaleUtils;
import org.apache.log4j.Logger;

public class LocalizedMessageUtil {
    private static final Logger logger = Logger.getLogger(LocalizedMessageUtil.class);
    public static final String I18N_RESOURCE_BASE_PACKAGE = "com.tandbergtv.watchpoint.i18n";
    public static final String I18N_RESOURCE_GROUP_CONTENT = "content";
    public static final String I18N_RESOURCE_GROUP_PARTNER = "partner";
    public static final String I18N_RESOURCE_GROUP_SITE = "site";
    public static final String I18N_RESOURCE_GROUP_REPORT = "report";
    public static final String I18N_RESOURCE_GROUP_RULE = "rule";
    public static final String I18N_RESOURCE_GROUP_SCHEDULE = "schedule";
    public static final String I18N_RESOURCE_GROUP_CONTRACT = "contract";
    private static final String I18N_RESOURCE_SERVICE_JNDI_LOOKUP_KEY = "cms/neptune/Neptune:service=com.tandbergtv.neptune.i18n.service.I18nResourceService";
    private MessageBundle messageBundle;
    private String group;
    private String defaultResourceBaseName;
    private ClassLoader cl;
    private ResourceBundle resourceBundle;

    public LocalizedMessageUtil(String group) {
        this.group = group;
        this.defaultResourceBaseName = "com.tandbergtv.watchpoint.i18n." + group;
    }

    public LocalizedMessageUtil(String group, String defaultResourceBaseName, ClassLoader cl) {
        this.group = group;
        this.defaultResourceBaseName = defaultResourceBaseName;
        this.cl = cl;
    }

    protected MessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            I18nResourceService i18nResourceService = (I18nResourceService)InjectionUtil.injectInstance((String)I18N_RESOURCE_SERVICE_JNDI_LOOKUP_KEY, I18nResourceService.class);
            this.messageBundle = i18nResourceService.getMessageBundleInstance();
        }
        return this.messageBundle;
    }

    public String getMessageValue(String key) {
        return this.getI18nMessage(key, LocalizedMessageUtil.getLocale());
    }

    public String getMessageValue(String key, Locale locale) {
        return this.getI18nMessage(key, locale);
    }

    private String getI18nMessage(String key, Locale locale) {
        String defaultValue = key;
        try {
            defaultValue = this.getResourceBundle(this.defaultResourceBaseName).getString(key);
        }
        catch (MissingResourceException e) {
            logger.debug((Object)("Refer to a nonexistent resource key:" + key));
        }
        return this.getMessageBundle().getMessageValue(key, this.group, defaultValue, locale);
    }

    public String getMessageValue(String key, Object ... args) {
        Locale locale = LocalizedMessageUtil.getLocale();
        String defaultValue = key;
        try {
            defaultValue = this.getResourceBundle(this.defaultResourceBaseName).getString(key);
            defaultValue = MessageFormat.format(defaultValue, args);
        }
        catch (MissingResourceException e) {
            logger.debug((Object)("Refer to a nonexistent resource key:" + key));
        }
        return this.getMessageBundle().getMessageValue(key, this.group, defaultValue, locale, args);
    }

    public String getMessageValueFromExternalResource(String externalPath, String externalFile, String key) {
        try {
            ResourceBundle externalBundle = this.getExternalResourceBundle(externalPath, externalFile);
            return this.getMessageBundle().getMessageValue(key, this.group, externalBundle.getString(key), LocalizedMessageUtil.getLocale());
        }
        catch (Exception e) {
            logger.error((Object)("fail to get resourceBundle . path:" + externalPath + " , file : " + externalFile + ", key: " + key), (Throwable)e);
            return String.format("!%s!", key);
        }
    }

    private ResourceBundle getExternalResourceBundle(String externalPath, String externalFile) throws MalformedURLException {
        File directory = new File(externalPath);
        URL[] urls = new URL[]{directory.toURI().toURL()};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        return ResourceBundle.getBundle(externalFile, LocalizedMessageUtil.getLocale(), aUrlCL);
    }

    protected ResourceBundle getResourceBundle(String resourceBaseName) {
        if (this.resourceBundle == null) {
            Locale defaultLocale = Locale.getDefault();
            this.resourceBundle = this.cl == null ? ResourceBundle.getBundle(resourceBaseName, defaultLocale) : ResourceBundle.getBundle(resourceBaseName, defaultLocale, this.cl);
        }
        return this.resourceBundle;
    }

    public static Locale getLocale() {
        return LocaleUtils.toLocale((String)I18nLocaleUtil.getThreadScopeLocaleValue());
    }
}

