/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDocumentUtility {
    private static final Logger logger = Logger.getLogger(XMLDocumentUtility.class);

    private XMLDocumentUtility() {
    }

    public static void setNodeValue(String expression, String value, XPath xPath, Node n) throws Exception {
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        node.setTextContent(value);
    }

    public static String getNodeValue(String expression, XPath xPath, Node n) throws Exception {
        if (expression.substring(0, 1).equals("$")) {
            return expression.substring(1);
        }
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        if (node != null) {
            return node.getTextContent();
        }
        return "";
    }

    public static NodeList getNodeSet(String expression, XPath xPath, Document doc) throws Exception {
        return (NodeList)xPath.evaluate(expression, doc, XPathConstants.NODESET);
    }

    public static String convertToString(Node node, String encoding) throws Exception {
        StringWriter w = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(new DOMSource(node), new StreamResult(w));
        return w.getBuffer().toString();
    }

    public static String convertToString(Node node) throws Exception {
        Document document;
        StringWriter w = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Document document2 = document = node instanceof Document ? (Document)Document.class.cast(node) : node.getOwnerDocument();
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        transformer.transform(new DOMSource(node), new StreamResult(w));
        return w.getBuffer().toString();
    }

    public static Document loadXml(String xmlString) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
    }

    public static Document loadXml(String xmlString, boolean isNSAware) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNSAware);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
    }

    public static Document loadFile(ClassLoader classloader, String filePath, boolean validating) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        InputStream stream = classloader.getResourceAsStream(filePath);
        return factory.newDocumentBuilder().parse(stream);
    }

    public static Document loadFile(String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(XMLDocumentUtility.class.getClassLoader(), filePath);
    }

    public static Document loadFile(ClassLoader classloader, String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(classloader, filePath, false);
    }

    public static Schema loadSchema(String path) throws Exception {
        InputStream stream = XMLDocumentUtility.class.getClassLoader().getResourceAsStream(path);
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Document document, String filePath) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath));
            transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(fos));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to close file: " + filePath), (Throwable)e);
                }
            }
        }
    }
}

