/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.content.util;

import com.ericsson.cms.content.util.ContentServerException;
import com.ericsson.cms.service.api.content.ContentServerClient;
import com.tandbergtv.content.image.ImageProperties;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ContentServerUtil {
    private static final String FILE_SIZE_UID = "010705";
    private static final String DELETE_MULTIPLE_FILE_UID = "010708";
    private static final String FILES_LIST_UID = "010709";
    private static final String FILE_MOVE_UID = "010713";
    private static final String DELETE_FOLDER_UID = "010720";
    private static final String CREATE_FOLDER_UID = "010721";
    private static final String CREATE_FILE_UID = "010758";
    private static final String IS_DIR_UID = "010759";
    private static final String FILES_SIZE_UID = "010760";
    private static final String FILE_LIST_MOVE_UID = "010766";
    private static final String TRUE_STR = "True";
    private static final String FILE_SIZE_PARAM_NAME = "FileSize";
    private static final String IS_DIRECTORY_PARAM_NAME = "IsDirectory";
    private static final String PATH_PARAM_NAME_PREFIX = "Path";
    private static final String REMOVE_EMPTY_PARENT_DIRS_PARAM_NAME = "RemoveEmptyParentDir";
    private static final String NACK_TYPE = "nack";
    private static final String ERROR_MSG = "error-message";
    private static final String PATH_PARAMETER = "Path";
    private static final String CONTENT_PARAMETER = "Content";
    private static final String RESULT_PARAMETER = "Result";
    private static final String SANFILE_XPATH = "//void[@property='absolutePath']/string";
    private static final String SANFILE_LENGTH_XPATH = "//void[@property='length']/long";
    private static final String SOURCE_PATH_PARAMETER = "SourcePath";
    private static final String DEST_PATH_PARAMETER = "DestinationPath";
    private static final String DIR_PARAMETER = "dir";
    private static final String INPUT_IMAGE_FILE_PATH = "inputImageFilePath";
    private static final String IMAGE_WIDTH = "imageWidth";
    private static final String IMAGE_HEIGTH = "imageHeight";
    private static final String IMAGE_SIZE = "imageSize";
    private static final String IMAGE_FILE_FORMAT = "imageFileFormat";
    private static final String IMAGE_CHECK_SUM = "imageChecksum";
    private static final String IMAGE_LAST_MODIFY_TIME = "imageLastModifyTime";
    private static final String OUTPUT_IMAGE_FILE_PATH = "outputImageFilePath";
    private static final String RESIZE_WIDTH = "resizeWidth";
    private static final String RESIZE_HEIGHT = "resizeHeight";
    private static final String FORCE_RESIZE = "forceResize";
    private static final String RESIZE_IMAGE = "01IM04";
    private static final String GET_IMAGE_PROPERTIES = "01IM09";
    private static final String FILES_PATH_LIST_UID = "010761";
    private static final String DIRECTORY = "Directory";
    private static final String FILE_LIST = "FileList";
    private static final String IS_SUB_FOLDER_INCLUDED = "IsSubFolderIncluded";
    private static ContentServerClient contentServerClient;
    private static final Logger logger;

    private ContentServerUtil() {
    }

    public static void writeToContentServer(String path, String content) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Path", path);
        param.put(CONTENT_PARAMETER, StringEscapeUtils.escapeXml((String)content));
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(CREATE_FILE_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    public static String fileSize(String path) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Path", path);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILE_SIZE_UID, param);
        return (String)response.get(FILE_SIZE_PARAM_NAME);
    }

    public static Map<String, String> fileListSize(String folderPath) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Path", folderPath);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILES_SIZE_UID, param);
        ContentServerUtil.validateResponse(response);
        HashMap<String, String> filePathSizeMap = new HashMap<String, String>();
        String result = (String)response.get(RESULT_PARAMETER);
        logger.debug((Object)("result: " + result));
        if (result != null) {
            List<String> pathList = ContentServerUtil.parseByXPath(result, SANFILE_XPATH);
            List<String> sizeList = ContentServerUtil.parseByXPath(result, SANFILE_LENGTH_XPATH);
            logger.debug((Object)("PathList: " + pathList));
            logger.debug((Object)("SizeList: " + sizeList));
            for (int i = 0; i < pathList.size(); ++i) {
                filePathSizeMap.put(pathList.get(i), sizeList.get(i));
            }
        }
        return filePathSizeMap;
    }

    public static List<String> getFilePaths(String folderPath) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DIRECTORY, folderPath);
        param.put(IS_SUB_FOLDER_INCLUDED, "true");
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILES_PATH_LIST_UID, param);
        ContentServerUtil.validateResponse(response);
        ArrayList<String> filePaths = new ArrayList<String>();
        for (Map.Entry entry : response.entrySet()) {
            if (entry.getKey() == null || !((String)entry.getKey()).startsWith(FILE_LIST)) continue;
            filePaths.add((String)entry.getValue());
        }
        return filePaths;
    }

    public static ImageProperties getImagePropeties(String filePath) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(INPUT_IMAGE_FILE_PATH, filePath);
        Map response = ContentServerUtil.getContentServerClient().invokeImageMagick(GET_IMAGE_PROPERTIES, param);
        ContentServerUtil.validateResponse(response);
        return new ImageProperties(filePath, Integer.parseInt((String)response.get(IMAGE_WIDTH)), Integer.parseInt((String)response.get(IMAGE_HEIGTH)), (String)response.get(IMAGE_SIZE), (String)response.get(IMAGE_CHECK_SUM), (String)response.get(IMAGE_FILE_FORMAT), (String)response.get(IMAGE_LAST_MODIFY_TIME));
    }

    public static String resizeImage(String inputImageFilePath, String outputImageFilePath, String resizeWidth, String resizeHeight) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(INPUT_IMAGE_FILE_PATH, inputImageFilePath);
        param.put(OUTPUT_IMAGE_FILE_PATH, outputImageFilePath);
        param.put(RESIZE_WIDTH, resizeWidth);
        param.put(RESIZE_HEIGHT, resizeHeight);
        param.put(FORCE_RESIZE, "true");
        Map response = ContentServerUtil.getContentServerClient().invokeImageMagick(RESIZE_IMAGE, param);
        String lastModifiedTime = (String)response.get(IMAGE_LAST_MODIFY_TIME);
        logger.debug((Object)("Resize image completed: resized image last modified time is: " + lastModifiedTime));
        return lastModifiedTime;
    }

    public static String appendCData(String param) {
        return "<![CDATA[" + param + "]]>";
    }

    public static String getFileContent(String path) {
        return ContentServerUtil.getContentServerClient().getFileContent(path);
    }

    public static String getFileContentWithRetry(String path) {
        return ContentServerUtil.getContentServerClient().getFileContentWithRetry(path);
    }

    public static byte[] getFileContentAsBytes(String path) {
        return ContentServerUtil.getContentServerClient().getFileContentAsBytes(path);
    }

    public static byte[] getImageContent(String path) {
        return ContentServerUtil.getContentServerClient().getImageFileContent(path);
    }

    public static void saveBase64ImageContent(String filePath, String base64ImageContent) {
        ContentServerUtil.getContentServerClient().saveBase64ImageContent(filePath, base64ImageContent);
    }

    public static boolean isDirectory(String path) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Path", path);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(IS_DIR_UID, param);
        ContentServerUtil.validateResponse(response);
        return TRUE_STR.equalsIgnoreCase((String)response.get(IS_DIRECTORY_PARAM_NAME));
    }

    public static List<String> listSubFilePaths(String path) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Path", path);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILES_LIST_UID, param);
        ContentServerUtil.validateResponse(response);
        String result = (String)response.get(RESULT_PARAMETER);
        if (result != null) {
            return ContentServerUtil.parseByXPath(result, SANFILE_XPATH);
        }
        return Collections.emptyList();
    }

    public static void moveFile(String sourcePath, String destPath) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(SOURCE_PATH_PARAMETER, sourcePath);
        param.put(DEST_PATH_PARAMETER, destPath);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILE_MOVE_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    public static void deleteFolder(String dir) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DIR_PARAMETER, dir);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(DELETE_FOLDER_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    public static void createFolder(String dir) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DIR_PARAMETER, dir);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(CREATE_FOLDER_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    public static void createFoldersAndMoveFiles(Collection<String> srcs, Collection<String> dests) {
        if (CollectionUtils.isEmpty(srcs) || CollectionUtils.isEmpty(dests)) {
            return;
        }
        String srcList = StringUtils.join(srcs, (char)',');
        String destList = StringUtils.join(dests, (char)',');
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("SourcePathList", srcList);
        param.put("DestinationPathList", destList);
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(FILE_LIST_MOVE_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    public static List<String> parseByXPath(String sanFileResult, String xpath) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Document doc = XmlUtil.borrowDocumentBuilder().parse(IOUtils.toInputStream((String)sanFileResult, (String)"UTF-8"));
            XPathExpression expression = XmlUtil.borrowXpathFactory().newXPath().compile(xpath);
            NodeList list = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < list.getLength(); ++i) {
                result.add(list.item(i).getTextContent());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Fail to use xpath: " + xpath + " parse the sanFile result: " + sanFileResult), (Throwable)e);
        }
        return result;
    }

    public static void deleteFileAndEmptyParentDir(Collection<String> paths) {
        HashMap<String, String> param = new HashMap<String, String>();
        int pathParamIndex = 0;
        for (String path : paths) {
            param.put("Path" + pathParamIndex, path);
            ++pathParamIndex;
        }
        param.put(REMOVE_EMPTY_PARENT_DIRS_PARAM_NAME, "true");
        Map response = ContentServerUtil.getContentServerClient().invokeFileManager(DELETE_MULTIPLE_FILE_UID, param);
        ContentServerUtil.validateResponse(response);
    }

    private static void validateResponse(Map<String, String> response) {
        if (response.get("ackType").equalsIgnoreCase(NACK_TYPE)) {
            throw new ContentServerException("nack response received , error message: " + response.get(ERROR_MSG));
        }
    }

    private static ContentServerClient getContentServerClient() {
        if (contentServerClient == null) {
            contentServerClient = new ContentServerClient();
        }
        return contentServerClient;
    }

    static {
        logger = Logger.getLogger(ContentServerUtil.class);
    }
}

