/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.predicate.PredicateBuilder;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.predicate.PredicateBuilderSimple;
import com.ericsson.cms.search.predicate.PredicateBuilderText;
import com.ericsson.cms.search.predicate.PredicateUtil;
import com.ericsson.cms.search.util.AssetPathValidator;
import com.ericsson.cms.sites.core.ISitesCacheService;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.TimeCodeUtil;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class AdvancedSearchQueryBuilder {
    private static Logger logger = Logger.getLogger(AdvancedSearchQueryBuilder.class);
    private ISitesCacheService sitesCacheService;
    private ElasticSearchIndexType indexType;

    public AdvancedSearchQueryBuilder(ElasticSearchIndexType indexType) {
        if (indexType == null) {
            throw new IllegalArgumentException("Index type is NULL.");
        }
        this.indexType = indexType;
    }

    public QueryBuilder build(ExpNode root) {
        QueryBuilder builder = this.processNode(root);
        if (ElasticSearchIndexType.SITE == this.indexType) {
            BoolQueryBuilder andBuilder = QueryBuilders.boolQuery();
            this.addChildFilter((QueryBuilder)andBuilder, builder, "AND");
            this.addChildFilter((QueryBuilder)andBuilder, this.createSitesFilter(), "AND");
            return andBuilder;
        }
        return builder;
    }

    public QueryBuilder buildSiteContentSearch() {
        if (ElasticSearchIndexType.SITE != this.indexType) {
            return null;
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        this.addChildFilter((QueryBuilder)builder, this.createSitesFilter(), "AND");
        return builder;
    }

    private void addChildFilter(QueryBuilder rootFilter, QueryBuilder childFilter, String strOp) {
        if (childFilter == null) {
            return;
        }
        if ("AND".equalsIgnoreCase(strOp)) {
            ((BoolQueryBuilder)rootFilter).must(childFilter);
        } else {
            ((BoolQueryBuilder)rootFilter).should(childFilter);
        }
    }

    private void validateAndFixAssetPath(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate is NULL.");
        }
        if (FieldType.ASSET == predicate.getFieldTypeLhs()) {
            String path = predicate.getFieldLeftSectionType();
            if (path == null) {
                throw new IllegalArgumentException("Asset path is NULL.");
            }
            if (ElasticSearchIndexType.MASTER == this.indexType || ElasticSearchIndexType.SITE == this.indexType) {
                String newPath = AssetPathValidator.getInstance().validateAndFixPackageAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            } else if (ElasticSearchIndexType.SERIES == this.indexType) {
                String newPath = AssetPathValidator.getInstance().validateAndFixSeriesAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            } else if (ElasticSearchIndexType.SEASON == this.indexType) {
                String newPath = AssetPathValidator.getInstance().validateAndFixSeasonAssetPath(path);
                predicate.setFieldLeftSectionType(newPath);
            }
        }
    }

    private void validateFieldXPath(Predicate predicate) {
        LogicalOperator operator = predicate.getOperator();
        if (operator == LogicalOperator.ISEMPTY || operator == LogicalOperator.CONTAINSUNPARSABLE || operator == LogicalOperator.MISSINGCONTENT) {
            return;
        }
        if (predicate.getFieldTypeLhs() == FieldType.ASSET) {
            String fieldPath = predicate.getFieldLeft();
            if (DataTypeMappingReader.getInstance().determineDataType(fieldPath) == null) {
                throw new IllegalArgumentException("Invalid field xpath: " + fieldPath);
            }
        }
    }

    private void fixDataType(Predicate predicate) {
        if (predicate.getDataType() == null) {
            String dataType = null;
            String fieldPath = predicate.getFieldLeft();
            if (fieldPath != null) {
                dataType = DataTypeMappingReader.getInstance().determineDataType(fieldPath);
            }
            if (dataType == null) {
                logger.warn((Object)("Could not determine data type for field " + fieldPath + ". Will use 'string' datatype."));
                dataType = "string";
            }
            predicate.setDataType(dataType);
        }
    }

    private void fixTimeCodeXPath(Predicate predicate) {
        if (predicate.getOperator().equals((Object)LogicalOperator.CONTAINSUNPARSABLE)) {
            return;
        }
        String fieldLeft = predicate.getFieldLeft();
        if (fieldLeft != null && fieldLeft.contains("TimeCode")) {
            predicate.setFieldLeft(fieldLeft + "Float");
            if (predicate instanceof PredicateRightValue) {
                List values = ((PredicateRightValue)predicate).getValue();
                if (values == null || values.isEmpty()) {
                    logger.warn((Object)("Predicate value is NULL for key " + PredicateUtil.getElasticSearchKey(predicate)));
                    return;
                }
                ArrayList<String> newValues = new ArrayList<String>();
                for (String value : values) {
                    newValues.add(String.valueOf(TimeCodeUtil.getInstance().toSeconds(value)));
                }
                ((PredicateRightValue)predicate).setValue(newValues);
            }
        }
    }

    private QueryBuilder createSitesFilter() {
        List siteIds = this.getSiteCacheService().getAllDistributionSiteIds().stream().map(id -> id.toString()).collect(Collectors.toList());
        PredicateRightValue predicate = new PredicateRightValue("distributionSiteId", null, null, siteIds, LogicalOperator.IN, Boolean.valueOf(false));
        return this.createValueFilter((Predicate)predicate);
    }

    private QueryBuilder createValueFilter(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate is NULL.");
        }
        LogicalOperator operator = predicate.getOperator();
        if (operator == null) {
            throw new IllegalArgumentException("Logical operator is NULL. ElasticSearch key = " + PredicateUtil.getElasticSearchKey(predicate));
        }
        this.validateAndFixAssetPath(predicate);
        this.validateFieldXPath(predicate);
        this.fixDataType(predicate);
        this.fixTimeCodeXPath(predicate);
        if (ElasticSearchIndexType.SITE == this.indexType && "trackingSiteId".equals(predicate.getFieldLeft())) {
            return this.buildTrackingSiteQueryBuilder(predicate, operator);
        }
        switch (operator) {
            case EQUAL: {
                return PredicateBuilderSimple.doEquals(predicate);
            }
            case LESSTHAN: {
                return PredicateBuilderSimple.doLessThan(predicate);
            }
            case LESSTHANEQUAL: {
                return PredicateBuilderSimple.doLessThanEqual(predicate);
            }
            case GREATERTHAN: {
                return PredicateBuilderSimple.doGreaterThan(predicate);
            }
            case GREATERTHANEQUAL: {
                return PredicateBuilderSimple.doGreaterThanEqual(predicate);
            }
            case ISNOTEMPTY: {
                return PredicateBuilderSimple.doExist(predicate);
            }
            case CONTAINS: {
                return PredicateBuilderText.doContains(predicate);
            }
            case LISTCONTAINS: {
                return PredicateBuilderText.doListContains(predicate);
            }
            case STARTSWITH: {
                return PredicateBuilderText.doStartsWith(predicate);
            }
            case ENDSWITH: {
                return PredicateBuilderText.doEndsWith(predicate);
            }
            case IN: {
                return PredicateBuilder.doIn(predicate);
            }
            case ISEMPTY: {
                return PredicateBuilder.doIsEmpty(predicate);
            }
            case CONTAINSUNPARSABLE: {
                return PredicateBuilder.doContainsUnparsable(predicate);
            }
            case MISSINGCONTENT: {
                return PredicateBuilder.doMissingContent(predicate);
            }
            case EQUALTOTODAY: {
                return PredicateBuilderDate.doEqualsToday(predicate);
            }
            case LESSTHANTODAY: {
                return PredicateBuilderDate.doLessThanToday(predicate);
            }
            case GREATERTHANTODAY: {
                return PredicateBuilderDate.doGreaterThanToday(predicate);
            }
            case BETWEEN: {
                return PredicateBuilderDate.doBetween(predicate);
            }
        }
        logger.error((Object)("Unsupported operator: " + operator.toString()));
        return null;
    }

    private QueryBuilder buildTrackingSiteQueryBuilder(Predicate predicate, LogicalOperator operator) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        if (LogicalOperator.EQUAL == operator) {
            return this.doEqualTrackingSiteQueryBuilder(predicate, key);
        }
        if (LogicalOperator.IN == operator) {
            return this.doInTrackingSiteQueryBuilder(predicate, key);
        }
        return null;
    }

    private QueryBuilder doEqualTrackingSiteQueryBuilder(Predicate predicate, String key) {
        Object value = PredicateUtil.getFirstValue(predicate, key);
        if (value == null) {
            return null;
        }
        predicate.setFieldLeft("/siteStatus/" + value);
        return PredicateBuilderSimple.doExist(predicate);
    }

    private QueryBuilder doInTrackingSiteQueryBuilder(Predicate predicate, String key) {
        if (predicate == null) {
            return null;
        }
        int count = PredicateUtil.getNumValues(predicate);
        if (count == 0) {
            return null;
        }
        Object[] values = PredicateUtil.getValues(predicate, key);
        if (values.length == 0) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List builders = predicate.getNot() != null && predicate.getNot() != false ? boolQueryBuilder.mustNot() : boolQueryBuilder.should();
        for (Object trackingSiteId : values) {
            builders.add(QueryBuilders.existsQuery((String)("/siteStatus/" + trackingSiteId)));
        }
        return boolQueryBuilder;
    }

    private QueryBuilder processNode(ExpNode root) {
        if (root instanceof ExpList) {
            ExpList expList = (ExpList)root;
            String strOp = expList.getOperator();
            BoolQueryBuilder rootFilter = QueryBuilders.boolQuery();
            for (ExpNode node : expList.getNodes()) {
                QueryBuilder childFilter = this.processNode(node);
                this.addChildFilter((QueryBuilder)rootFilter, childFilter, strOp);
            }
            return rootFilter;
        }
        if (root instanceof ExpValue) {
            ExpValue expValue = (ExpValue)root;
            Predicate predicate = expValue.getPredicate();
            return this.createValueFilter(predicate);
        }
        return null;
    }

    private ISitesCacheService getSiteCacheService() {
        if (this.sitesCacheService == null) {
            this.sitesCacheService = (ISitesCacheService)InjectionUtil.injectInstance((String)"cms/cms_sites_impl/SitesCacheService", ISitesCacheService.class);
        }
        return this.sitesCacheService;
    }
}

