/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ESMetadataFields;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchSeasonBuilder {
    private XContentBuilder bld;
    private ESMetadataFields metadataFields = new ESMetadataFields();

    public XContentBuilder createSeason(Title title, Asset season) throws Exception {
        if (title == null) {
            throw new IllegalArgumentException("Title is null.");
        }
        if (season == null) {
            throw new IllegalArgumentException("Season asset is null.");
        }
        this.bld = XContentFactory.jsonBuilder();
        this.bld.prettyPrint();
        this.bld.startObject();
        this.addNonMetadataFields(title, season);
        this.addMetadataFields(season);
        this.bld.endObject();
        return this.bld;
    }

    private void addNonMetadataFields(Title title, Asset season) throws Exception {
        ElasticSearchUtil.addField(this.bld, "seriesTitleId", title.getId());
        if (title.getDocumentId() == null) {
            throw new IllegalArgumentException("Series document ID is null.");
        }
        ElasticSearchUtil.addField(this.bld, "seriesDocumentId", title.getDocumentId());
        if (title.getPartnerId() != null) {
            ElasticSearchUtil.addField(this.bld, "partnerId", title.getPartnerId());
        }
        ElasticSearchUtil.addField(this.bld, "seasonId", season.getId());
    }

    private void addMetadataFields(Asset season) throws Exception {
        this.processAsset(season);
        this.metadataFields.build(this.bld);
    }

    private void processAsset(Asset asset) {
        if (asset == null) {
            return;
        }
        String assetPath = asset.getPath();
        for (Field field : asset.getFields()) {
            String key = ElasticSearchUtil.createElasticSearchKey(assetPath, field.getTtvXPath());
            if (!field.getParsable().booleanValue()) continue;
            this.processFieldForAdvancedSearch(key, field);
        }
        for (Relation r : asset.getRelations()) {
            this.processAsset(r.getTargetAsset());
        }
    }

    private void processFieldForAdvancedSearch(String key, Field field) {
        this.metadataFields.addField(key, field.getTypedValue());
    }
}

