/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ESMetadataFields;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.search.util.QuickSearchStringBuilder;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.search.util.TitleUpdateUtil;
import com.ericsson.cms.search.util.UpdateSiteStatusInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchSiteTitleBuilder {
    private static Logger logger = Logger.getLogger(ElasticSearchSiteTitleBuilder.class);
    private static final String ERR_COULD_NOT_UPDATE_TITLE_SOURCE = "Could not update title source";
    static final String FAILURE_REASON_MARKER = "FAILUREREASONMARKER";
    static final String ES_KEY_DIST_FAILURE_REASON = "distributionFailureReason";
    static final String ES_KEY_DIST_SITE_ID = "distributionSiteId";
    static final String ES_KEY_DIST_STATUS = "distributionStatus";
    static final String ES_KEY_DIST_STATUS_UPDATED_TIME = "distributionStatusUpdatedTime";
    static final String ES_KEY_DIST_STATUS_DETAIL = "distributionStatusDetail";
    static final String ES_KEY_QUICK_SEARCH = "quickSearch";
    private XContentBuilder bld;
    private QuickSearchStringBuilder quickSearchBuilder;
    private ESMetadataFields metadataFields = new ESMetadataFields();

    public XContentBuilder createTitle(Title title, SiteStatusCollection statuses) throws Exception {
        if (title == null) {
            throw new IllegalArgumentException("Title is null.");
        }
        this.quickSearchBuilder = new QuickSearchStringBuilder();
        this.bld = XContentFactory.jsonBuilder();
        this.bld.prettyPrint();
        this.bld.startObject();
        this.addNonMetadataFields(title, statuses);
        this.addMetadataFields(title);
        SiteStatusCollection.DistributionSiteStatusEntry distStatus = statuses.getDistributionSiteStatus();
        String failureReason = distStatus != null ? distStatus.failureReason : "";
        this.addQuickSearchField(failureReason);
        this.bld.endObject();
        return this.bld;
    }

    private void addSiteInfo(SiteStatusCollection statuses) {
        List<SiteStatusCollection.TrackingSiteStatusEntry> list;
        if (statuses == null) {
            return;
        }
        SiteStatusCollection.DistributionSiteStatusEntry distStatus = statuses.getDistributionSiteStatus();
        if (distStatus != null) {
            ElasticSearchUtil.addField(this.bld, ES_KEY_DIST_SITE_ID, distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, ES_KEY_DIST_STATUS, distStatus.status);
            ElasticSearchUtil.addField(this.bld, ES_KEY_DIST_STATUS_UPDATED_TIME, distStatus.statusUpdatedTime);
            ElasticSearchUtil.addField(this.bld, ES_KEY_DIST_STATUS_DETAIL, distStatus.statusDetail);
            ElasticSearchUtil.addField(this.bld, ES_KEY_DIST_FAILURE_REASON, distStatus.failureReason);
            String key = ElasticSearchUtil.createSiteStatusKey(distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, key, distStatus.status);
            String keyUpdateTime = ElasticSearchUtil.createSiteStatusUpdatedTimeKey(distStatus.siteId);
            ElasticSearchUtil.addField(this.bld, keyUpdateTime, distStatus.statusUpdatedTime);
        }
        if ((list = statuses.getTrackingSiteStatuses()) != null && !list.isEmpty()) {
            ArrayList<Integer> trackingSiteIds = new ArrayList<Integer>();
            for (SiteStatusCollection.TrackingSiteStatusEntry entry : list) {
                String key = ElasticSearchUtil.createSiteStatusKey(entry.siteId);
                ElasticSearchUtil.addField(this.bld, key, entry.status);
                String keyUpdateTime = ElasticSearchUtil.createSiteStatusUpdatedTimeKey(entry.siteId);
                ElasticSearchUtil.addField(this.bld, keyUpdateTime, entry.statusUpdatedTime);
                trackingSiteIds.add(entry.siteId);
            }
        }
    }

    private void addQuickSearchField(String failureReason) throws IOException {
        this.bld.field(ES_KEY_QUICK_SEARCH, this.updateQuickSearchValue(this.quickSearchBuilder.getQuickSearchString(), failureReason));
    }

    private void addNonMetadataFields(Title title, SiteStatusCollection statuses) {
        Group rootGroup;
        Asset rootAsset;
        ElasticSearchUtil.addField(this.bld, "id", title.getId());
        this.quickSearchBuilder.addTitleId(title.getId());
        if (title.getContentClassId() != null) {
            ElasticSearchUtil.addField(this.bld, "contentClassId", title.getContentClassId());
        }
        if (title.getPartnerId() != null) {
            ElasticSearchUtil.addField(this.bld, "partnerId", title.getPartnerId());
        }
        if (title.getStatus() != null) {
            ElasticSearchUtil.addField(this.bld, "status", title.getStatus().toString());
        }
        if (title.getOriginalId() != null) {
            ElasticSearchUtil.addField(this.bld, "originalId", title.getOriginalId());
        }
        if (title.getCreateDate() != null) {
            ElasticSearchUtil.addField(this.bld, "createDate", title.getCreateDate());
        }
        if (title.getLastModifiedTime() != null) {
            ElasticSearchUtil.addField(this.bld, "lastModifiedTime", title.getLastModifiedTime());
        }
        if (title.getRetirementDate() != null) {
            ElasticSearchUtil.addField(this.bld, "retirementDate", title.getRetirementDate());
        }
        if ((rootAsset = title.getAsset()) != null && rootAsset instanceof Group && (rootGroup = (Group)rootAsset).getReferencedTitleIds() != null && !rootGroup.getReferencedTitleIds().isEmpty()) {
            ElasticSearchUtil.addArray(this.bld, "referencedTitleIds", rootGroup.getReferencedTitleIds());
        }
        this.addSiteInfo(statuses);
    }

    private void addMetadataFields(Title title) throws Exception {
        if (title == null) {
            return;
        }
        Asset rootAsset = title.getAsset();
        if (rootAsset == null) {
            return;
        }
        if (rootAsset.getFields() == null || rootAsset.getFields().isEmpty()) {
            ElasticSearchUtil.addField(this.bld, "/PACKAGE", true);
        } else {
            this.processAsset(rootAsset);
            this.metadataFields.build(this.bld);
        }
    }

    private void processAsset(Asset asset) {
        if (asset == null) {
            return;
        }
        String assetPath = asset.getPath();
        for (Field field : asset.getFields()) {
            String key = ElasticSearchUtil.createElasticSearchKey(assetPath, field.getTtvXPath());
            if (!field.getParsable().booleanValue()) continue;
            this.processFieldForAdvancedSearch(key, field);
            this.quickSearchBuilder.addField(field);
        }
        for (Relation r : asset.getRelations()) {
            this.processAsset(r.getTargetAsset());
        }
    }

    private void processFieldForAdvancedSearch(String key, Field field) {
        Object typedValue = field.getTypedValue();
        this.metadataFields.addField(key, typedValue);
        this.handleTimeCode(key, typedValue);
    }

    private void handleTimeCode(String key, Object typedValue) {
        if (key.contains("/TimeCode")) {
            TimeCodeType timecode = (TimeCodeType)typedValue;
            this.metadataFields.addField(key + "Float", Float.valueOf(timecode.getFloatValue()));
        }
    }

    public Map<String, Object> updateTitle(Map<String, Object> oldSource, UpdateSiteStatusInfo siteInfo) {
        if (siteInfo.siteType == null) {
            logger.error((Object)"Site type is null");
            return null;
        }
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        if (siteInfo.siteType == UpdateSiteStatusInfo.SiteType.DISTRIBUTION) {
            newFields.put(ElasticSearchUtil.createSiteStatusKey(siteInfo.siteId), siteInfo.status);
            newFields.put(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(siteInfo.siteId), ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime));
            newFields.put(ES_KEY_DIST_STATUS, siteInfo.status);
            newFields.put(ES_KEY_DIST_STATUS_UPDATED_TIME, ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime));
            newFields.put(ES_KEY_DIST_STATUS_DETAIL, Integer.toString(siteInfo.statusDetail));
            newFields.put(ES_KEY_DIST_FAILURE_REASON, siteInfo.failureReason);
            this.updateQuickSearch(oldSource, siteInfo.failureReason);
            try {
                return TitleUpdateUtil.updateSource(oldSource, newFields);
            }
            catch (Exception ex) {
                logger.error((Object)ERR_COULD_NOT_UPDATE_TITLE_SOURCE, (Throwable)ex);
                return null;
            }
        }
        if (siteInfo.siteType == UpdateSiteStatusInfo.SiteType.TRACKING) {
            newFields.put(ElasticSearchUtil.createSiteStatusKey(siteInfo.siteId), siteInfo.status);
            newFields.put(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(siteInfo.siteId), ElasticSearchUtil.processDate(siteInfo.statusUpdatedTime));
            try {
                return TitleUpdateUtil.updateSource(oldSource, newFields);
            }
            catch (Exception ex) {
                logger.error((Object)ERR_COULD_NOT_UPDATE_TITLE_SOURCE, (Throwable)ex);
                return null;
            }
        }
        logger.error((Object)("Unsupported site type: " + (Object)((Object)siteInfo.siteType)));
        return null;
    }

    private void updateQuickSearch(Map<String, Object> source, String failureReason) {
        String oldQuickSearchValue = (String)source.get(ES_KEY_QUICK_SEARCH);
        if (oldQuickSearchValue == null) {
            return;
        }
        source.put(ES_KEY_QUICK_SEARCH, this.updateQuickSearchValue(oldQuickSearchValue, failureReason));
    }

    public Map<String, Object> updateTitle(Map<String, Object> oldSource, SiteStatusCollection statuses) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        SiteStatusCollection.DistributionSiteStatusEntry distStatus = statuses.getDistributionSiteStatus();
        newFields.put(ES_KEY_DIST_STATUS, distStatus.status);
        newFields.put(ElasticSearchUtil.createSiteStatusKey(distStatus.siteId), distStatus.status);
        newFields.put(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(distStatus.siteId), ElasticSearchUtil.processDate(distStatus.statusUpdatedTime));
        newFields.put(ES_KEY_DIST_STATUS_UPDATED_TIME, ElasticSearchUtil.processDate(distStatus.statusUpdatedTime));
        newFields.put(ES_KEY_DIST_STATUS_DETAIL, Integer.toString(distStatus.statusDetail));
        newFields.put(ES_KEY_DIST_FAILURE_REASON, distStatus.failureReason);
        this.updateQuickSearch(oldSource, distStatus.failureReason);
        for (SiteStatusCollection.TrackingSiteStatusEntry site : statuses.getTrackingSiteStatuses()) {
            newFields.put(ElasticSearchUtil.createSiteStatusKey(site.siteId), site.status);
            newFields.put(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(site.siteId), ElasticSearchUtil.processDate(site.statusUpdatedTime));
        }
        try {
            return TitleUpdateUtil.updateSource(oldSource, newFields);
        }
        catch (Exception ex) {
            logger.error((Object)ERR_COULD_NOT_UPDATE_TITLE_SOURCE, (Throwable)ex);
            return null;
        }
    }

    private String updateQuickSearchValue(String oldQuickSearchValue, String failureReason) {
        int markerIndex = oldQuickSearchValue.lastIndexOf(FAILURE_REASON_MARKER);
        if (markerIndex == -1) {
            return oldQuickSearchValue + " " + FAILURE_REASON_MARKER + " " + failureReason;
        }
        oldQuickSearchValue = oldQuickSearchValue.substring(0, markerIndex + FAILURE_REASON_MARKER.length());
        return oldQuickSearchValue + " " + failureReason;
    }
}

