/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.IElasticSearchTitleSyncCleanupService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class ElasticSearchTitleSyncCleanupService
implements IElasticSearchTitleSyncCleanupService,
Service {
    private static final Logger logger = Logger.getLogger(ElasticSearchTitleSyncCleanupService.class);
    private static final String SERVICE_NAME = "ElasticSearch Title Sync Cleanup Service";
    private ITitleManager titleManager = null;
    private IElasticSearchService esService = null;

    @Override
    public void syncTitles(int batchSize) throws Exception {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            List list = session.createSQLQuery("select title_type, title_id from mdm_elastic_search_failed_titles").setMaxResults(batchSize).list();
            if (list.size() != 0) {
                logger.info((Object)("Synchronizing " + list.size() + " titles with ElasticSearch"));
                for (Object data : list) {
                    if (data instanceof Object[]) {
                        Object[] data_array = (Object[])data;
                        if (data_array[0] != null && data_array[1] != null) {
                            Number title_type = (Number)data_array[0];
                            Number title_id = (Number)data_array[1];
                            this.resyncTitle(ElasticSearchIndexType.values()[title_type.intValue()], title_id.longValue());
                            continue;
                        }
                        logger.warn((Object)"Looks like we have a failed search title record with a NULL value for title type. Cannot handle this type of data, so ignoring. Will need to be culled from the queue by hand.");
                        continue;
                    }
                    logger.error((Object)("Unexpected value received from Hibernate. Was expecting a pair of numbers but got \"" + data + "\" of type " + data.getClass()));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception while trying to sync titles to ES", (Throwable)ex);
            throw ex;
        }
    }

    private void resyncTitle(ElasticSearchIndexType titleType, long titleId) {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        if (this.titleManager.isActive(Long.valueOf(titleId))) {
            logger.debug((Object)("Resyncing Title " + titleId + " with ElasticSearch"));
            try {
                if (this.esService.saveTitle(title)) {
                    this.esService.clearSuccessfulTitleId(titleId);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Could not save title " + titleId + " in ElasticSearch."), (Throwable)ex);
            }
        } else {
            logger.debug((Object)("Deleting title " + titleId + " from ElasticSearch."));
            try {
                if (this.esService.deleteTitle(titleType, title)) {
                    this.esService.clearSuccessfulTitleId(titleId);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Could not delete title " + titleId + " from ElasticSearch."), (Throwable)ex);
            }
        }
    }

    public void start() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        this.titleManager = (ITitleManager)registry.lookup(ITitleManager.class);
        this.esService = (IElasticSearchService)registry.lookup(IElasticSearchService.class);
    }

    public void stop() {
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }
}

