/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;

public abstract class BaseBulkTitleCommand
implements ElasticSearchConnection.Command {
    private static Logger logger = Logger.getLogger(BaseBulkTitleCommand.class);
    protected String typeName = "_doc";
    protected Map<String, Title> map = new HashMap<String, Title>();
    protected Collection<Title> titles;
    protected List<Title> failedTitles = new ArrayList<Title>();
    protected boolean bulkSuccess = true;
    protected BulkProcessor bulkProcessor;

    public BaseBulkTitleCommand(Collection<Title> titles, Client client) {
        this.titles = titles;
        for (Title title : titles) {
            this.map.put(String.valueOf(title.getId()), title);
        }
        this.bulkProcessor = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse bulkResponse) {
                if (bulkResponse.hasFailures()) {
                    bulkResponse.forEach(response -> BaseBulkTitleCommand.this.handleFailedId(response.getId()));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                BaseBulkTitleCommand.this.handleFailure(failure);
            }
        }).setConcurrentRequests(0).build();
    }

    public List<Title> getFailedTitles() {
        return this.failedTitles;
    }

    protected void handleFailedId(String id) {
        this.failedTitles.add(this.map.get(id));
        logger.error((Object)("Could not index title " + id));
    }

    protected void handleFailure(Throwable failure) {
        logger.error((Object)("Failed to bulk index titles " + this.titles.size()), failure);
        this.bulkSuccess = false;
    }

    protected void executeBulk() {
        this.bulkProcessor.flush();
        this.bulkProcessor.close();
    }
}

