/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.search.util.SortHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public abstract class BaseSearchCommand
implements ElasticSearchConnection.Command {
    protected static Logger logger = Logger.getLogger(BaseSearchCommand.class);
    protected String indexName;
    protected SearchParameters params;
    private TitleSearchResult searchResult;
    protected List<Long> searchResultIds;
    private Exception exception;

    public BaseSearchCommand(SearchParameters params) {
        if (params == null) {
            throw new IllegalArgumentException("SearchParametsrs is null");
        }
        this.params = params;
        this.indexName = ElasticSearchUtil.getElasticSearchIndexName(params.getTitleIndexType());
        if (this.indexName == null) {
            String str = "Could not determine ElasticSearch title index name";
            throw new IllegalArgumentException(str);
        }
    }

    public TitleSearchResult getSearchResult() {
        return this.searchResult;
    }

    public List<Long> getSearchResultIds() {
        return this.searchResultIds;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected SearchRequestBuilder createSearchRequest(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        SearchRequestBuilder bld = esClient.prepareSearch(new String[]{this.indexName});
        bld.setFetchSource(this.getIncludeFields(), null);
        if (this.params.getSortField() != null) {
            SortBuilder sort = SortHandler.getSortBuilder(this.params);
            sort.order(this.params.isAscSortOrder() ? SortOrder.ASC : SortOrder.DESC);
            if (sort instanceof FieldSortBuilder) {
                ((FieldSortBuilder)sort).unmappedType("keyword");
            }
            bld.addSort(sort);
        }
        if (this.params.getPageSize() > 0) {
            bld.setFrom(this.params.getPageFrom());
            bld.setSize(this.params.getPageSize());
        }
        return bld;
    }

    private String[] getIncludeFields() {
        HashSet fieldSet = new HashSet();
        if (this.params.getFields() != null) {
            this.params.getFields().forEach(f -> fieldSet.add(f.getKey()));
        }
        return (String[])fieldSet.stream().toArray(String[]::new);
    }

    protected void search(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest is null");
        }
        SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
        this.processSearchResult(resp);
    }

    protected void processSearchResult(SearchResponse resp) {
        TitleSearchResult result = new TitleSearchResult();
        long totalHits = resp.getHits().getTotalHits();
        result.setCount(totalHits);
        result.setHasMoreResults(totalHits > (long)(this.params.getPageFrom() + this.params.getPageSize()));
        for (SearchHit hit : resp.getHits().getHits()) {
            TitleSearchResult.SearchRow row = ElasticSearchUtil.createSearchRow(this.params.getFields(), hit);
            result.addRow(row);
        }
        this.searchResult = result;
    }

    protected void searchIds(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest is null");
        }
        SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
        this.searchResultIds = new ArrayList<Long>();
        for (SearchHit hit : resp.getHits().getHits()) {
            long titleId = Long.parseLong(hit.getId());
            this.searchResultIds.add(titleId);
        }
    }

    protected QueryBuilder addPartnerIdFilter(QueryBuilder rootFilter, long[] partnerIds) {
        if (partnerIds == null || partnerIds.length == 0) {
            return rootFilter;
        }
        TermsQueryBuilder partnerFilter = QueryBuilders.termsQuery((String)"partnerId", (long[])partnerIds);
        if (rootFilter == null) {
            return partnerFilter;
        }
        if (rootFilter instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)rootFilter).must((QueryBuilder)partnerFilter);
            return rootFilter;
        }
        return QueryBuilders.boolQuery().must(rootFilter).must((QueryBuilder)partnerFilter);
    }
}

