/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public abstract class ClusterWideSearchBaseCommand
implements ElasticSearchConnection.Command {
    protected static Logger logger = Logger.getLogger(ClusterWideSearchBaseCommand.class);
    private TitleSearchResult searchResult;
    private List<Long> searchResultIds;
    private Exception exception;
    private Set<String> searchFields;
    private String searchValue;

    public ClusterWideSearchBaseCommand(Set<String> fields, String value) {
        if (fields == null || fields.size() == 0) {
            throw new IllegalArgumentException("Fields is null or empty");
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value is null or empty");
        }
        this.searchFields = fields;
        this.searchValue = value;
    }

    public TitleSearchResult getSearchResult() {
        return this.searchResult;
    }

    public void setSearchResult(TitleSearchResult result) {
        this.searchResult = result;
    }

    public List<Long> getSearchResultIds() {
        return this.searchResultIds;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected SearchRequestBuilder createSearchRequest(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        SearchRequestBuilder bld = esClient.prepareSearch(new String[0]);
        Object[] searchFieldsArray = this.searchFields.toArray();
        String[] serchFieldsStringArray = (String[])Arrays.copyOf(searchFieldsArray, searchFieldsArray.length, String[].class);
        bld.setQuery((QueryBuilder)QueryBuilders.multiMatchQuery((Object)this.searchValue, (String[])serchFieldsStringArray));
        return bld;
    }

    protected void search(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (searchRequest == null) {
            throw new IllegalArgumentException("SearchRequest is null");
        }
        SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
        this.processSearchResult(resp);
    }

    abstract void processSearchResult(SearchResponse var1);

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            this.search(esConnection, searchRequest);
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }
}

