/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.springframework.util.CollectionUtils;

public class DeleteSeasonsCommand
extends BaseTitleCommand {
    protected static Logger logger = Logger.getLogger(DeleteSeasonsCommand.class);
    private Title title;

    public DeleteSeasonsCommand(Title title) {
        super(ElasticSearchIndexType.SEASON);
        this.title = title;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            TransportClient client = esConnection.getTransportClient();
            List assets = this.title.getAssets("SEASON");
            if (CollectionUtils.isEmpty((Collection)assets)) {
                return true;
            }
            BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
            for (Asset asset : assets) {
                bulkRequestBuilder.add(client.prepareDelete(this.indexName, this.typeName, String.valueOf(asset.getId())));
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.execute().actionGet(esConnection.getWriteTimeoutMs());
            if (bulkResponse.hasFailures()) {
                logger.error((Object)("Failed to delete seasons of series title with id = " + this.title.getId()));
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not delete seasons of series title with id = " + this.title.getId()), (Throwable)ex);
            return false;
        }
    }
}

