/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseBulkTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.Client;
import org.springframework.util.CollectionUtils;

public class DeleteSeasonsInBulkCommand
extends BaseBulkTitleCommand {
    private static Logger logger = Logger.getLogger(DeleteSeasonsInBulkCommand.class);
    private Map<Title, List<Asset>> titleSeasonMap;
    private Map<Long, Title> assetTitleMap = new HashMap<Long, Title>();

    public DeleteSeasonsInBulkCommand(Map<Title, List<Asset>> titleSeasonMap, Client client) {
        super(titleSeasonMap.keySet(), client);
        this.titleSeasonMap = titleSeasonMap;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            if (CollectionUtils.isEmpty(this.titleSeasonMap)) {
                return true;
            }
            for (Map.Entry<Title, List<Asset>> entry : this.titleSeasonMap.entrySet()) {
                Title title = entry.getKey();
                List<Asset> seasonAssets = entry.getValue();
                for (Asset asset : seasonAssets) {
                    this.assetTitleMap.put(asset.getId(), title);
                    this.bulkProcessor.add(new DeleteRequest(ElasticSearchUtil.getElasticSearchIndexName(ElasticSearchIndexType.SEASON), this.typeName, String.valueOf(asset.getId())));
                }
            }
            this.executeBulk();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to bulk delete title seasons.", (Throwable)e);
            return false;
        }
        return this.bulkSuccess;
    }

    @Override
    protected void handleFailedId(String id) {
        this.failedTitles.add(this.assetTitleMap.get(id));
        logger.error((Object)("Could not delete title season " + id));
    }
}

