/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.cmd.BaseBulkTitleCommand;
import com.ericsson.cms.search.cmd.DeleteSeasonsInBulkCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.Client;

public class DeleteTitleInBulkCommand
extends BaseBulkTitleCommand {
    private static Logger logger = Logger.getLogger(DeleteSeasonsInBulkCommand.class);

    public DeleteTitleInBulkCommand(List<Title> titles, Client client) {
        super(titles, client);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            for (Title title : this.titles) {
                this.bulkProcessor.add(new DeleteRequest(ElasticSearchUtil.getElasticSearchIndexName(ElasticSearchUtil.getTitleType(title)), this.typeName, String.valueOf(title.getId())));
            }
            this.executeBulk();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to bulk delete titles " + this.map.keySet()), (Throwable)e);
            return false;
        }
        return this.bulkSuccess;
    }
}

