/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import java.util.Map;
import org.apache.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class DeleteTrackingSiteTitleCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(DeleteTrackingSiteTitleCommand.class);
    private String strTitleId;
    private int siteId;

    public DeleteTrackingSiteTitleCommand(int trackingSiteId) {
        super(ElasticSearchIndexType.SITE);
        this.siteId = trackingSiteId;
    }

    public DeleteTrackingSiteTitleCommand(long titleId, int trackingSiteId) {
        this(trackingSiteId);
        this.strTitleId = String.valueOf(titleId);
    }

    public void setTitleId(long titleId) {
        this.strTitleId = String.valueOf(titleId);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient client = esConnection.getTransportClient();
        try {
            GetRequestBuilder request = client.prepareGet(this.indexName, this.typeName, this.strTitleId);
            GetResponse response = (GetResponse)request.execute().actionGet(esConnection.getReadTimeoutMs());
            long version = response.getVersion();
            Map source = response.getSourceAsMap();
            String key = ElasticSearchUtil.createSiteStatusKey(this.siteId);
            if (!source.containsKey(key)) {
                return true;
            }
            source.remove(key);
            IndexRequestBuilder saveRequest = client.prepareIndex(this.indexName, this.typeName, this.strTitleId);
            saveRequest.setSource(source);
            saveRequest.setVersion(version);
            saveRequest.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not delete tracking site title " + this.strTitleId), (Throwable)ex);
            return false;
        }
    }
}

