/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.TrackingStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.hibernate.jdbc.Work;

public class GetSiteTitleStatusesWork
implements Work {
    private long siteTitleId;
    private SiteStatusCollection statuses;

    public GetSiteTitleStatusesWork(long siteTitleId) {
        this.siteTitleId = siteTitleId;
        this.statuses = new SiteStatusCollection();
    }

    public SiteStatusCollection getStatuses() {
        return this.statuses;
    }

    public void execute(Connection connection) throws SQLException {
        String sql = "select 'D', siteid, status, status_updated_time, status_detail, failure_reason from sites_distsitetitle where titleid = ? union all select 'T', siteid, status, status_updated_time, 0, '' from sites_tracksitetitle where titleid = ?";
        try (PreparedStatement st = connection.prepareStatement(sql);
             ResultSet rs = this.executeQuery(st, this.siteTitleId);){
            DistributionStatus[] distStatuses = DistributionStatus.values();
            TrackingStatus[] trackingStatuses = TrackingStatus.values();
            while (rs.next()) {
                String status;
                boolean isTrackingSiteRecord;
                String type = rs.getString(1);
                int siteId = rs.getInt(2);
                int statusId = rs.getInt(3);
                Date statusUpdatedTime = new Date(rs.getTimestamp(4).getTime());
                boolean isDistSiteRecord = "D".equals(type) && statusId >= 0 && statusId < distStatuses.length;
                boolean bl = isTrackingSiteRecord = "T".equals(type) && statusId >= 0 && statusId < trackingStatuses.length;
                if (isDistSiteRecord) {
                    status = distStatuses[statusId].name();
                    int statusDetail = rs.getInt(5);
                    String failureReason = rs.getString(6);
                    this.statuses.setDistributionStatus(siteId, status, statusUpdatedTime, statusDetail, failureReason);
                    continue;
                }
                if (!isTrackingSiteRecord) continue;
                status = trackingStatuses[statusId].name();
                this.statuses.addTrackingSiteStatus(siteId, status, statusUpdatedTime);
            }
        }
    }

    private ResultSet executeQuery(PreparedStatement st, long siteTitleId) throws SQLException {
        st.setLong(1, siteTitleId);
        st.setLong(2, siteTitleId);
        return st.executeQuery();
    }
}

