/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.BaseSearchCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.util.CollectionUtils;

public class MultiFieldSearchCommand
extends BaseSearchCommand {
    private String searchString;

    public MultiFieldSearchCommand(String searchString, SearchParameters params) {
        super(params);
        this.searchString = searchString;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            if (!CollectionUtils.isEmpty(this.params.getSearchFieldNames())) {
                MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)this.searchString, (String[])this.params.getSearchFieldNames().toArray(new String[this.params.getSearchFieldNames().size()]));
                searchRequest.setPostFilter((QueryBuilder)multiMatchQueryBuilder);
            }
            this.search(esConnection, searchRequest);
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }
}

