/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseBulkTitleCommand;
import com.ericsson.cms.search.cmd.SaveTitleUtils;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;

public class SaveTitleInBulkCommand
extends BaseBulkTitleCommand {
    private static Logger logger = Logger.getLogger(SaveTitleInBulkCommand.class);
    private boolean cacheAssetsRequiringFiles;

    public SaveTitleInBulkCommand(List<Title> titles, boolean cacheAssetsRequiringFiles, Client client) {
        super(titles, client);
        this.cacheAssetsRequiringFiles = cacheAssetsRequiringFiles;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            for (Title title : this.titles) {
                ElasticSearchIndexType titleType = ElasticSearchUtil.getTitleType(title);
                this.bulkProcessor.add(new IndexRequest(ElasticSearchUtil.getElasticSearchIndexName(titleType), this.typeName, String.valueOf(title.getId())).source(SaveTitleUtils.computeTitleSource(title, titleType, this.cacheAssetsRequiringFiles)));
            }
            this.executeBulk();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to bulk index titles " + this.titles.size()), (Throwable)e);
            return false;
        }
        return this.bulkSuccess;
    }
}

