/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.AdvancedSearchQueryBuilder;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.BaseSearchCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class TitleCountCommand
extends BaseSearchCommand {
    private ExpNode rootNode;
    private long titleCount;

    public TitleCountCommand(ExpNode rootNode, SearchParameters params) {
        super(params);
        this.rootNode = rootNode;
    }

    public long getTitleCount() {
        return this.titleCount;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            TransportClient esClient = esConnection.getTransportClient();
            SearchRequestBuilder countRequest = esClient.prepareSearch(new String[]{this.indexName}).setSize(0);
            QueryBuilder rootFilter = null;
            if (this.rootNode != null) {
                AdvancedSearchQueryBuilder query = new AdvancedSearchQueryBuilder(this.params.getTitleIndexType());
                rootFilter = query.build(this.rootNode);
            }
            QueryBuilder filter = this.addPartnerIdFilter(rootFilter, this.params.getPartnerIds());
            logger.debug((Object)("getTitleCount filter: " + filter));
            if (filter != null) {
                BoolQueryBuilder query = QueryBuilders.boolQuery().must(filter);
                countRequest.setQuery((QueryBuilder)query);
            }
            SearchResponse resp = (SearchResponse)countRequest.execute().actionGet(esConnection.getReadTimeoutMs());
            this.titleCount = resp.getHits().getTotalHits();
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }
}

