/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import java.util.Date;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;

public class TotalDurationCommand
implements ElasticSearchConnection.Command {
    private double totalDuration;
    private Exception exception;
    private String providerId;
    private Date startDate;
    private Date endDate;

    public TotalDurationCommand(String providerId, Date startDate, Date endDate) {
        this.providerId = providerId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public double getTotalDuration() {
        return this.totalDuration;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            Sum sumAgg;
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            QueryBuilder filter = this.createFilter();
            SumAggregationBuilder sumAggregation = AggregationBuilders.sum((String)"totalDuration");
            sumAggregation.field("/PACKAGE/TITLE/durationSec");
            FilterAggregationBuilder filterAggregation = AggregationBuilders.filter((String)"filter", (QueryBuilder)filter);
            filterAggregation.subAggregation((AggregationBuilder)sumAggregation);
            searchRequest.addAggregation((AggregationBuilder)filterAggregation);
            SearchResponse resp = (SearchResponse)searchRequest.execute().actionGet(esConnection.getReadTimeoutMs());
            Filter rootAgg = (Filter)resp.getAggregations().get("filter");
            if (rootAgg != null && (sumAgg = (Sum)rootAgg.getAggregations().get("totalDuration")) != null) {
                this.totalDuration = sumAgg.getValue();
            }
            return true;
        }
        catch (Exception ex) {
            this.exception = ex;
            return false;
        }
    }

    private SearchRequestBuilder createSearchRequest(ElasticSearchConnection esConnection) {
        String indexName = ElasticSearchUtil.getElasticSearchIndexName(ElasticSearchIndexType.MASTER);
        TransportClient esClient = esConnection.getTransportClient();
        SearchRequestBuilder searchRequest = esClient.prepareSearch(new String[]{indexName});
        searchRequest.setFetchSource(false);
        searchRequest.setSize(0);
        return searchRequest;
    }

    private QueryBuilder createFilter() {
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"/PACKAGE/TITLE/durationSec"));
        if (this.providerId != null) {
            filter.must((QueryBuilder)QueryBuilders.termQuery((String)"/PACKAGE/Fields/ProviderInfo/Identifier/Id", (String)this.providerId.trim().toLowerCase()));
        }
        if (this.startDate != null) {
            filter.must(PredicateBuilderDate.createGreaterThanEqualFilter("createDate", this.startDate));
        }
        if (this.endDate != null) {
            filter.must(PredicateBuilderDate.createLessThanEqualFilter("createDate", this.endDate));
        }
        return filter;
    }
}

