/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.predicate.PredicateUtil;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.neptune.util.GlobalDateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class PredicateBuilderDate {
    private static final String LOG_PREFIX_INVALID_DATE = "Invalid date ";
    private static Logger logger = Logger.getLogger(PredicateBuilderDate.class);

    private PredicateBuilderDate() {
    }

    public static Calendar getTodayCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    static String toElasticSearchDateString(Date date) {
        return GlobalDateFormatUtil.formatDateTime((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static Date parseElasticSearchDateString(String str) {
        SimpleDateFormat esFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        try {
            return esFormat.parse(str);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static QueryBuilder doEquals(Predicate predicate) {
        boolean isNot;
        Date date;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        try {
            date = DateUtil.convertDate((String)value.trim());
        }
        catch (DateParseException ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + value.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)key).lt((Object)strDateFrom)).should((QueryBuilder)QueryBuilders.rangeQuery((String)key).gte((Object)strDateTo));
        }
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom).lt((Object)strDateTo);
    }

    public static QueryBuilder createEqualsFilter(String key, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom).lt((Object)strDateTo);
    }

    public static QueryBuilder doLessThan(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        Date date = null;
        try {
            date = DateUtil.convertDate((String)value.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + value.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom);
        }
        return QueryBuilders.rangeQuery((String)key).lt((Object)strDateFrom);
    }

    public static QueryBuilder doLessThanEqual(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        Date date = null;
        try {
            date = DateUtil.convertDate((String)value.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + value.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).gte((Object)strDateTo);
        }
        return QueryBuilders.rangeQuery((String)key).lt((Object)strDateTo);
    }

    public static QueryBuilder createLessThanEqualFilter(String key, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        return QueryBuilders.rangeQuery((String)key).lt((Object)strDateTo);
    }

    public static QueryBuilder doGreaterThan(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        Date date = null;
        try {
            date = DateUtil.convertDate((String)value.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + value.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).lt((Object)strDateTo);
        }
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateTo);
    }

    public static QueryBuilder doGreaterThanEqual(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        Date date = null;
        try {
            date = DateUtil.convertDate((String)value.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + value.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).lt((Object)strDateFrom);
        }
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom);
    }

    public static QueryBuilder createGreaterThanEqualFilter(String key, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom);
    }

    public static QueryBuilder doEqualsToday(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Calendar cal = PredicateBuilderDate.getTodayCalendar();
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)key).lt((Object)strDateFrom)).should((QueryBuilder)QueryBuilders.rangeQuery((String)key).gte((Object)strDateTo));
        }
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom).lt((Object)strDateTo);
    }

    public static QueryBuilder doLessThanToday(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Calendar cal = PredicateBuilderDate.getTodayCalendar();
        int addAmount = PredicateUtil.getFirstIntValue(predicate, key);
        cal.add(5, addAmount);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom);
        }
        return QueryBuilders.rangeQuery((String)key).lt((Object)strDateFrom);
    }

    public static QueryBuilder doBetween(Predicate predicate) {
        Date dateTo;
        Date dateFrom;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String strFrom = PredicateUtil.getFirstRawStringValue(predicate, key);
        try {
            dateFrom = DateUtil.convertDate((String)strFrom.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + strFrom.trim()), (Throwable)ex);
            return null;
        }
        String strTo = PredicateUtil.getSecondRawStringValue(predicate, key);
        try {
            dateTo = DateUtil.convertDate((String)strTo.trim());
        }
        catch (Exception ex) {
            logger.error((Object)(LOG_PREFIX_INVALID_DATE + strTo.trim()), (Throwable)ex);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFrom);
        PredicateBuilderDate.clearTime(cal);
        String strDateFrom = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        cal.setTime(dateTo);
        PredicateBuilderDate.clearTime(cal);
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateFrom).lt((Object)strDateTo);
    }

    public static QueryBuilder doGreaterThanToday(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        Calendar cal = PredicateBuilderDate.getTodayCalendar();
        int addAmount = PredicateUtil.getFirstIntValue(predicate, key);
        cal.add(5, addAmount);
        cal.add(5, 1);
        String strDateTo = PredicateBuilderDate.toElasticSearchDateString(cal.getTime());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() != false;
        if (isNot) {
            return QueryBuilders.rangeQuery((String)key).lt((Object)strDateTo);
        }
        return QueryBuilders.rangeQuery((String)key).gte((Object)strDateTo);
    }
}

