/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.exception.PredicateValidateException;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class PredicateUtil {
    private static Logger logger = Logger.getLogger(PredicateUtil.class);
    public static final String CONTENT_CLASS = "contentClassId";
    public static final String DISTRIBUTION_STATUS = "distributionStatus";
    public static final String TRACKING_SITE_ID = "trackingSiteId";
    private static final String PREDICATE_IS_NULL = "Predicate is NULL.";
    private static final String COULD_NOT_PARSE = "Could not parse ";
    private static final String PREDICATE_IS_NULL_FOR_KEY = "Predicate value is NULL for key ";

    private PredicateUtil() {
    }

    public static String getAssetPath(Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        return FieldType.ASSET == predicate.getFieldTypeLhs() ? predicate.getFieldLeftSectionType() : null;
    }

    public static String getElasticSearchKey(Predicate predicate) {
        if (predicate == null) {
            logger.warn((Object)PREDICATE_IS_NULL);
            return null;
        }
        String assetPath = PredicateUtil.getAssetPath(predicate);
        String fieldPath = predicate.getFieldLeft();
        return ElasticSearchUtil.createElasticSearchKey(assetPath, fieldPath);
    }

    public static Object createTypedObject(String value, String dataType) {
        if ("string".equalsIgnoreCase(dataType)) {
            return value.toLowerCase().trim();
        }
        if ("integer".equalsIgnoreCase(dataType) || "long".equalsIgnoreCase(dataType)) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (Exception ex) {
                logger.error((Object)(COULD_NOT_PARSE + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("float".equalsIgnoreCase(dataType) || "double".equalsIgnoreCase(dataType)) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (Exception ex) {
                logger.error((Object)(COULD_NOT_PARSE + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("date".equalsIgnoreCase(dataType)) {
            try {
                Date date = DateUtil.convertDate((String)value.trim());
                return PredicateBuilderDate.toElasticSearchDateString(date);
            }
            catch (Exception ex) {
                logger.error((Object)(COULD_NOT_PARSE + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("time".equalsIgnoreCase(dataType)) {
            try {
                SimpleDateFormat fromFormat = new SimpleDateFormat("HH:mm:ss");
                Date time = fromFormat.parse(value.trim());
                return PredicateBuilderDate.toElasticSearchDateString(time);
            }
            catch (Exception ex) {
                logger.error((Object)(COULD_NOT_PARSE + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("boolean".equalsIgnoreCase(dataType)) {
            return "true".equalsIgnoreCase(value);
        }
        logger.error((Object)("Unknown data type " + dataType));
        return value;
    }

    public static Object getFirstValue(Predicate predicate, String key) {
        if (predicate == null) {
            logger.warn((Object)PREDICATE_IS_NULL);
            return null;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (CollectionUtils.isEmpty((Collection)values)) {
                logger.warn((Object)(PREDICATE_IS_NULL_FOR_KEY + key));
                return null;
            }
            String dataType = predicate.getDataType();
            return PredicateUtil.createTypedObject((String)values.get(0), dataType);
        }
        logger.warn((Object)(PREDICATE_IS_NULL_FOR_KEY + key));
        return null;
    }

    public static Object[] getValues(Predicate predicate, String key) {
        if (predicate == null) {
            logger.warn((Object)PREDICATE_IS_NULL);
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (CollectionUtils.isEmpty((Collection)values)) {
                logger.warn((Object)(PREDICATE_IS_NULL_FOR_KEY + key));
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
            String dataType = predicate.getDataType();
            int size = values.size();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = PredicateUtil.createTypedObject((String)values.get(i), dataType);
            }
            return array;
        }
        logger.warn((Object)(PREDICATE_IS_NULL_FOR_KEY + key));
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public static int getFirstIntValue(Predicate predicate, String key) {
        String str = PredicateUtil.getFirstRawStringValue(predicate, key);
        return Integer.parseInt(str);
    }

    public static String getFirstRawStringValue(Predicate predicate, String key) {
        if (predicate == null) {
            throw new PredicateValidateException(PREDICATE_IS_NULL);
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.isEmpty()) {
                throw new PredicateValidateException(PREDICATE_IS_NULL_FOR_KEY + key);
            }
            return ((String)values.get(0)).trim();
        }
        throw new PredicateValidateException(PREDICATE_IS_NULL_FOR_KEY + key);
    }

    public static String getSecondRawStringValue(Predicate predicate, String key) {
        if (predicate == null) {
            throw new PredicateValidateException(PREDICATE_IS_NULL);
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.size() < 2) {
                throw new PredicateValidateException("Second predicate value is NULL for key " + key);
            }
            return ((String)values.get(1)).trim();
        }
        throw new PredicateValidateException("Second predicate value is NULL for key " + key);
    }

    public static int getNumValues(Predicate predicate) {
        if (predicate == null) {
            return 0;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            return values == null ? 0 : values.size();
        }
        return 0;
    }

    public static void verifyContentClassPredicate(Predicate predicate) {
        if (!PredicateUtil.isContentClassPredicate(predicate)) {
            return;
        }
        IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        List contentClassValues = ((PredicateRightValue)predicate).getValue();
        for (int i = 0; i < contentClassValues.size(); ++i) {
            String contentClassValue = (String)contentClassValues.get(i);
            if (StringUtils.isNumeric((String)contentClassValue)) continue;
            try {
                Long contentClassId = contentClassService.getContentClassIdByName(contentClassValue);
                if (contentClassId == null || contentClassId == 0L) {
                    throw new PredicateValidateException("No content class is found for content class name \"" + contentClassValue + "\" in the rule.");
                }
                contentClassValues.set(i, Long.toString(contentClassId));
                continue;
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)e);
                throw new PredicateValidateException("Failed to find content class for content class name \"" + contentClassValue + "\" in the rule.");
            }
        }
    }

    private static boolean isContentClassPredicate(Predicate predicate) {
        return predicate instanceof PredicateRightValue && CONTENT_CLASS.equals(predicate.getFieldLeft()) && ((PredicateRightValue)predicate).getValue() != null;
    }
}

