/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.ericsson.neptune.es.CmsTransportClient;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;

public class ElasticSearchConnection {
    private static Logger logger = Logger.getLogger(ElasticSearchConnection.class);
    private CmsTransportClient client;

    public ElasticSearchConnection(String configFile) {
        logger.info((Object)"Creating ElasticSearch connection...");
        this.client = new CmsTransportClient(configFile);
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public long getWriteTimeoutMs() {
        return this.client.getSettings().getWriteTimeoutMs();
    }

    public long getReadTimeoutMs() {
        return this.client.getSettings().getReadTimeoutMs();
    }

    public TransportClient getTransportClient() {
        return this.client.getTransportClient();
    }

    private void sleep() {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public boolean runCommandOnce(Command cmd) {
        return cmd.run(this);
    }

    public boolean runCommandHA(Command cmd) {
        long t2;
        long t1 = System.currentTimeMillis();
        do {
            if (cmd.run(this)) {
                return true;
            }
            this.sleep();
        } while ((t2 = System.currentTimeMillis()) - t1 <= this.getWriteTimeoutMs());
        return false;
    }

    public static interface CommandResults {
        public boolean wasSuccessful();
    }

    public static interface CommandWithResults<A extends CommandResults> {
        public A run(ElasticSearchConnection var1);
    }

    public static interface Command {
        public boolean run(ElasticSearchConnection var1);
    }
}

