/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.ericsson.cms.search.IElasticSearchService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ElasticSearchSettingsUtil {
    private static final Map<String, Integer> INDEX_MAX_RESULT_WINDOW_MAP = new HashMap<String, Integer>();
    private static final int DEFAULT_MAX_RESULT_WINDOW = 10000;
    private static final String MAX_RESULT_WINDOW_SETTING_NAME = "index.max_result_window";
    private static final Logger LOGGER = Logger.getLogger(ElasticSearchSettingsUtil.class);
    private static IElasticSearchService elasticSearchService;

    private ElasticSearchSettingsUtil() {
    }

    public static Integer getIndexMaxResultWindow(String index) {
        if (!INDEX_MAX_RESULT_WINDOW_MAP.containsKey(index)) {
            try {
                String indexSetting = ElasticSearchSettingsUtil.getElasticSearchService().getElasticSearchIndexSetting(index, MAX_RESULT_WINDOW_SETTING_NAME);
                if (StringUtils.isNotEmpty((String)indexSetting)) {
                    INDEX_MAX_RESULT_WINDOW_MAP.put(index, Integer.valueOf(indexSetting));
                } else {
                    INDEX_MAX_RESULT_WINDOW_MAP.put(index, 10000);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"fail to get the max result window setting from elasticsearch , will use the default value .", (Throwable)e);
                INDEX_MAX_RESULT_WINDOW_MAP.put(index, 10000);
            }
        }
        return INDEX_MAX_RESULT_WINDOW_MAP.get(index);
    }

    private static IElasticSearchService getElasticSearchService() {
        if (elasticSearchService == null) {
            elasticSearchService = (IElasticSearchService)ServiceRegistry.getDefault().lookup("ElasticSearchService");
        }
        return elasticSearchService;
    }
}

