/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.tandbergtv.metadatamanager.model.Field;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QuickSearchStringBuilder {
    private StringBuilder stringBuilder = new StringBuilder();

    public void addTitleId(Long titleId) {
        if (titleId == null) {
            return;
        }
        this.stringBuilder.append(titleId).append(" ");
    }

    public void addField(Field field) {
        if (field == null) {
            return;
        }
        String type = field.getDataType();
        Object value = field.getTypedValue();
        if (value == null) {
            return;
        }
        if ("string".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type)) {
            this.stringBuilder.append(value);
            this.stringBuilder.append(" ");
        } else if ("date".equalsIgnoreCase(type)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = df.format((Date)value);
            this.stringBuilder.append(str);
            this.stringBuilder.append(" ");
        } else if ("time".equalsIgnoreCase(type)) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            String str = df.format((Date)value);
            this.stringBuilder.append(str);
            this.stringBuilder.append(" ");
        } else if ("timecode".equalsIgnoreCase(type)) {
            this.stringBuilder.append(value);
            this.stringBuilder.append(" ");
        }
    }

    public String getQuickSearchString() {
        return this.stringBuilder.toString();
    }
}

