/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.sites.core.ISitesCacheService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

public class SortHandler {
    private static final String SITE_NAME_SORT_SCRIPT = "params.factor[doc['distributionSiteId'].value.toString()]";
    private static ISitesCacheService sitesCacheService;

    private SortHandler() {
    }

    public static SortBuilder getSortBuilder(SearchParameters searchParameters) {
        if (ElasticSearchIndexType.SITE.equals((Object)searchParameters.getTitleIndexType())) {
            switch (searchParameters.getSortField()) {
                case "distributionSiteId": {
                    HashMap<String, Map> params = new HashMap<String, Map>();
                    params.put("factor", SortHandler.getSiteCacheService().getDistSiteIdAndNameIndexMap());
                    return SortBuilders.scriptSort((Script)new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", SITE_NAME_SORT_SCRIPT, new HashMap(), params), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.STRING);
                }
                case "status": {
                    return SortBuilders.fieldSort((String)"distributionStatus");
                }
                case "statusUpdateTime": {
                    return SortBuilders.fieldSort((String)"distributionStatusUpdatedTime");
                }
            }
            return SortBuilders.fieldSort((String)searchParameters.getSortField());
        }
        return SortBuilders.fieldSort((String)searchParameters.getSortField());
    }

    private static ISitesCacheService getSiteCacheService() {
        if (sitesCacheService == null) {
            sitesCacheService = (ISitesCacheService)InjectionUtil.injectInstance((String)"cms/cms_sites_impl/SitesCacheService", ISitesCacheService.class);
        }
        return sitesCacheService;
    }
}

