/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalRegister;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.hibernate.GetOptionsWork;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.service.TitlesAssociatedException;
import com.tandbergtv.content.contentclass.util.ContentClassIngestMerger;
import com.tandbergtv.content.contentclass.util.ContentClassTitleBuilder;
import com.tandbergtv.content.contentclass.util.ContentClassUIMerger;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ContentClassMessage;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate
implements IContentClassService {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);
    private static Map<Long, ContentClass> contentClassCache = new ConcurrentHashMap<Long, ContentClass>();
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("content");
    private static final String ERROR_MSG_GET_CONTENT_CLASS_LIST = "Unable to get a list of content classes";
    private static final String ERROR_MSG_GET_CONTENT_CLASS = "Unable to get a content class with id = ";
    private static final String ERROR_MSG_GET_CONTENT_CLASS_PARTNER = "Unable to get content class partner with contentClassId = {0} and partnerId = {1} ";
    private static final String ERROR_MSG_DETERMINE_CATEGORY = "Failed to determine if the title is a category package";

    @Transactional
    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException {
        String queryStr = "select max(updatedate) as updatedate from PMM_CONTENT_CLASS";
        Session session = HibernateContext.getContext().getCurrentSession();
        NativeQuery query = session.createSQLQuery(queryStr);
        query.addScalar("updatedate", (Type)new TimestampType());
        return this.parse(query.uniqueResult(), Date.class);
    }

    @Transactional
    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            GetOptionsWork work = new GetOptionsWork();
            session.doWork((Work)work);
            return work.getFieldsWithOptions();
        }
        catch (Exception ex) {
            String msg = this.getI18nString("errorUnableGetListOfContentClass", new Object[0]);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public List<ContentClass> getAllContentClassesWithoutMetadata() {
        ArrayList<ContentClass> contentClasses = new ArrayList<ContentClass>();
        contentClassCache.values().forEach(cc -> contentClasses.add(cc.createCopyWithoutMetadata()));
        return contentClasses;
    }

    @Transactional
    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        List results = null;
        String sql = "select content_class_id, partner_id from pmm_content_class_partner";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            NativeQuery query = session.createSQLQuery(sql);
            query.addScalar("content_class_id", (Type)StandardBasicTypes.LONG);
            query.addScalar("partner_id", (Type)StandardBasicTypes.LONG);
            results = query.list();
        }
        catch (HibernateException e) {
            logger.error((Object)"Unable to get a list of content class partners", (Throwable)e);
            String msg = this.getI18nString("errorUnableGetListOfContentClassPartners", new Object[0]);
            throw new ContentClassPersistenceException(msg, (Throwable)e);
        }
        if (null == results || results.isEmpty()) {
            return new ArrayList<ContentClassPartner>();
        }
        ArrayList<ContentClassPartner> partnerList = new ArrayList<ContentClassPartner>();
        results.forEach(result -> {
            Object[] data = this.parse(result, Object[].class);
            if (null == data || data.length < 2) {
                return;
            }
            ContentClassPartner ccp = new ContentClassPartner(this.parse(data[0], Long.class).longValue(), this.parse(data[1], Long.class).longValue());
            partnerList.add(ccp);
        });
        return partnerList;
    }

    @Transactional
    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long partnerId) throws ContentClassPersistenceException {
        List list;
        String sql = "select c.id, c.typeId, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?1";
        try {
            list = HibernateContext.getContext().getCurrentSession().createQuery(sql).setParameter(1, (Object)partnerId).list();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)ex);
            String msg = this.getI18nString("errorUnableGetListOfContentClass", new Object[0]);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return this.createContentClassList(list);
    }

    private boolean isContentClassDataVaild(Object[] data) {
        return null != data && data.length >= 6;
    }

    private ContentClass buildContentClass(Object[] data) {
        ContentClass cc = new ContentClass();
        cc.setId(this.parse(data[0], Long.class).longValue());
        Integer typeId = this.parse(data[1], Integer.class);
        if (null == typeId) {
            return null;
        }
        cc.setType(ContentClassHibernateFactory.getContentClassType(typeId));
        cc.setName(this.parse(data[2], String.class));
        cc.setDescription(this.parse(data[3], String.class));
        Integer specialUsageId = this.parse(data[4], Integer.class);
        if (null == specialUsageId) {
            return null;
        }
        cc.setSpecialUsage(ContentClassHibernateFactory.getSpecialUsage(specialUsageId));
        cc.setDefault(this.parse(data[5], Boolean.class).booleanValue());
        return cc;
    }

    private List<ContentClass> createContentClassList(List<?> tmpList) {
        if (tmpList == null || tmpList.isEmpty()) {
            return new ArrayList<ContentClass>();
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        tmpList.forEach(e -> {
            Object[] data = this.parse(e, Object[].class);
            if (!this.isContentClassDataVaild(data)) {
                return;
            }
            ContentClass cc = this.buildContentClass(data);
            if (null == cc) {
                return;
            }
            list.add(cc);
        });
        return list;
    }

    public ContentClass.Type getContentClassTypeById(long id) throws ContentClassPersistenceException {
        ContentClass cc = this.getContentClassById(id);
        if (null == cc) {
            return null;
        }
        return cc.getType();
    }

    @Transactional
    public ContentClass getContentClassById(long id) throws ContentClassPersistenceException {
        ContentClass cc = contentClassCache.get(id);
        if (null != cc) {
            return cc.createCopy();
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                throw new ContentClassPersistenceException(this.getI18nString("errorContentClassNotExist", id));
            }
            cc = this.buildContentClass(cch);
            contentClassCache.put(id, cc);
            return cc.createCopy();
        }
        catch (Exception ex) {
            String msg = ERROR_MSG_GET_CONTENT_CLASS + id;
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableGetContentClass", id);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private ContentClass buildContentClass(ContentClassEntity contentClassEntity) throws ContentClassPersistenceException {
        try {
            HibernateContext.getContext().getCurrentSession().evict((Object)contentClassEntity);
            return ContentClassHibernateFactory.createContentClass(contentClassEntity);
        }
        catch (ContentClassPersistenceException | HibernateException e) {
            String msg = "Exception occurs when parsing ContentClassEntity to ContentClass.";
            logger.error((Object)msg, e);
            throw e;
        }
    }

    @Transactional
    private List<ContentClass> loadAllContentClassesFromDatabase() throws ContentClassPersistenceException {
        List result = null;
        try {
            result = HibernateContext.getContext().getCurrentSession().createCriteria(ContentClassEntity.class).list();
        }
        catch (HibernateException e) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)e);
            String msg = this.getI18nString("errorUnableGetListOfContentClass", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        if (null == result || result.isEmpty()) {
            return new ArrayList<ContentClass>();
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        for (Object e : result) {
            ContentClass cc;
            ContentClassEntity contentClassEntity = this.parse(e, ContentClassEntity.class);
            if (null == contentClassEntity || null == (cc = this.buildContentClass(contentClassEntity))) continue;
            list.add(cc);
        }
        return list;
    }

    public String getContentClassMetadataXml(long id) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                String msg = this.getI18nString("errorContentClassNotExist", id);
                throw new ContentClassPersistenceException(msg);
            }
            session.evict((Object)cch);
            return cch.metadataXml;
        }
        catch (Exception ex) {
            String msg = "Unable to get a content classes with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableGetContentClass", id);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return;
        }
        try {
            ContentClassEntity cch = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            HibernateContext.getContext().getCurrentSession().saveOrUpdate((Object)cch);
            contentClass.setId(cch.id);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableSaveContentClassWithId", contentClass.getId());
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterSave(contentClass));
    }

    @Transactional
    public void deleteContentClassById(long id) throws ContentClassPersistenceException {
        this.doDeleteContentClassById(id);
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterDelete(id));
    }

    public String getServiceName() {
        return "ContentClassService";
    }

    public void start() {
        try {
            this.loadAllContentClassesFromDatabase().forEach(e -> contentClassCache.put(e.getId(), (ContentClass)e));
        }
        catch (ContentClassPersistenceException e2) {
            logger.error((Object)ERROR_MSG_GET_CONTENT_CLASS_LIST, (Throwable)e2);
        }
    }

    public void stop() {
    }

    @Transactional
    public ContentClassPartner getContentClassPartner(long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) throws ContentClassPersistenceException {
        try {
            ContentClassPartner ccp;
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                if (enforceCCPartnerAssociation) {
                    String msg = this.getI18nString("errorContentClassAndPartnerNotAssociated", contentClassId, partnerId);
                    throw new ContentClassPersistenceException(msg);
                }
                ccp = new ContentClassPartner(contentClassId, partnerId);
            } else {
                ccp = ContentClassHibernateFactory.createContentClassPartner(entity);
            }
            String sql = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ?1 and p.id_ = ?2";
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(1, (Object)contentClassId);
            query.setParameter(2, (Object)partnerId);
            Object[] result = (Object[])query.uniqueResult();
            if (result == null) {
                String msg = this.getI18nString("errorInvalidContentClassOrPartner", contentClassId, partnerId);
                throw new ContentClassPersistenceException(msg);
            }
            ccp.setContentClassName((String)result[0]);
            ccp.setPartnerName((String)result[1]);
            ccp.setProviderId((String)result[2]);
            return ccp;
        }
        catch (ContentClassPersistenceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(ERROR_MSG_GET_CONTENT_CLASS_PARTNER, contentClassId, partnerId);
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorInvalidContentClassOrPartner", contentClassId, partnerId);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public ContentClassPartner getContentClassPartnerMetadata(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                return null;
            }
            session.evict((Object)entity);
            return ContentClassHibernateFactory.createContentClassPartner(entity);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(ERROR_MSG_GET_CONTENT_CLASS_PARTNER, contentClassId, partnerId);
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableGetCcPartnerWithCcIdAndPartnerId", contentClassId, partnerId);
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public void saveContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        if (ccp == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = ContentClassHibernateFactory.createContentClassPartnerEntity(ccp);
            session.saveOrUpdate((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableSaveContentClassPartnerWithPartnerId", ccp.getContentClassId(), ccp.getPartnerId());
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public void deleteContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        if (ccp == null) {
            return;
        }
        boolean titlesFound = false;
        try {
            String sql = "select id_ from pmm_title where content_class_id = ?1 and partner_id = ?2 and titlestatusid <> 5";
            Session session = HibernateContext.getContext().getCurrentSession();
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(1, (Object)ccp.getContentClassId());
            query.setParameter(2, (Object)ccp.getPartnerId());
            query.addScalar("id_", (Type)StandardBasicTypes.LONG);
            query.setMaxResults(1);
            if (query.uniqueResult() != null) {
                titlesFound = true;
            }
        }
        catch (Exception ex) {
            String message = "Unable to check if there are titles created with content class [" + ccp.getContentClassId() + "] for partner [" + ccp.getPartnerId() + "]";
            logger.error((Object)message, (Throwable)ex);
            message = this.getI18nString("errorUnableCheckifTitlesCreatedWithContentClass", ccp.getContentClassId(), ccp.getPartnerId());
            throw new ContentClassPersistenceException(message, (Throwable)ex);
        }
        if (titlesFound) {
            String msg = this.getI18nString("errorTitlesInSystemCreatedWithCc", ccp.getContentClassId(), ccp.getPartnerId());
            throw new TitlesAssociatedException(msg);
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(ccp.getContentClassId(), ccp.getPartnerId());
            session.delete((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableDeleteCcPartnerWithCcAndPartnerId", ccp.getContentClassId(), ccp.getPartnerId());
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private String getI18nString(String key, Object ... args) {
        return messageUtil.getMessageValue(key, args);
    }

    private boolean isSelfPartner(String userName) throws HibernateException {
        String sql = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?1";
        Session session = HibernateContext.getContext().getCurrentSession();
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameter(1, (Object)userName);
        query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
        int count = (Integer)query.uniqueResult();
        return count > 0;
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        return this.getContentClassPartnerMap(userName, false);
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        return this.getContentClassPartnerMap(userName, true);
    }

    private Map<Long, ContentClassPartnerList> parseContentClassPartnerList(List<?> list) {
        if (null == list || list.isEmpty()) {
            return new HashMap<Long, ContentClassPartnerList>();
        }
        HashMap<Long, ContentClassPartnerList> map = new HashMap<Long, ContentClassPartnerList>();
        list.forEach(e -> {
            Object[] data = this.parse(e, Object[].class);
            if (null == data || data.length < 5) {
                return;
            }
            Long partnerId = this.parse(data[0], Long.class);
            String partnerName = this.parse(data[1], String.class);
            Long ccId = this.parse(data[2], Long.class);
            String ccName = this.parse(data[3], String.class);
            Integer ccType = this.parse(data[4], Integer.class);
            ContentClassPartnerList ccpList = (ContentClassPartnerList)map.get(partnerId);
            if (ccpList == null) {
                ccpList = new ContentClassPartnerList(partnerId.longValue());
                ccpList.setPartnerName(partnerName);
                map.put(partnerId, ccpList);
            }
            ccpList.addContentClass(ccId.longValue(), ccName, ccType.intValue());
        });
        return map;
    }

    @Transactional
    private Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName, boolean categoryContentClassOnly) throws ContentClassPersistenceException {
        List results;
        try {
            NativeQuery query;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (this.isSelfPartner(userName)) {
                StringBuilder sql = new StringBuilder(" select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype  from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp  where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1 and p.partnertype in (0,2) ");
                if (categoryContentClassOnly) {
                    sql.append(" and c.content_class_type_id = 2 ");
                }
                query = session.createSQLQuery(sql.toString());
            } else {
                StringBuilder sql = new StringBuilder(" select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype  from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u  where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id  and p.isactive = 1 and p.partnertype in (0,2) and u.username = ?1 ");
                if (categoryContentClassOnly) {
                    sql.append(" and c.content_class_type_id = 2 ");
                }
                query = session.createSQLQuery(sql.toString());
                query.setParameter(1, (Object)userName);
            }
            query.addScalar("pid", (Type)StandardBasicTypes.LONG);
            query.addScalar("pname", (Type)StandardBasicTypes.STRING);
            query.addScalar("cid", (Type)StandardBasicTypes.LONG);
            query.addScalar("cname", (Type)StandardBasicTypes.STRING);
            query.addScalar("ctype", (Type)StandardBasicTypes.INTEGER);
            results = query.list();
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner map";
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableGetCcPartnerMap", new Object[0]);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return this.parseContentClassPartnerList(results);
    }

    public Long getContentClassIdByName(String name) {
        if (null == name) {
            return null;
        }
        for (ContentClass cc : contentClassCache.values()) {
            if (!name.equals(cc.getName())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getDefaultContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!cc.isDefault()) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getCategoryContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Category.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getOfferContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Offer.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    public Long getSeriesContentClassId() {
        for (ContentClass cc : contentClassCache.values()) {
            if (!ContentClass.Type.Series.equals((Object)cc.getType())) continue;
            return cc.getId();
        }
        return null;
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        ContentClass cc = this.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException(this.getI18nString("errorContentClassNotExist", contentClassId));
        }
        ContentClassPartner ccp = this.getContentClassPartner(contentClassId, partnerId, true);
        if (ccp == null) {
            throw new ContentClassPersistenceException(this.getI18nString("errorUnableGetCcPartnerWithCcIdAndPartnerId", contentClassId, partnerId));
        }
        ccp.setContentClassType(cc.getType());
        ContentClassIngestMerger merger = new ContentClassIngestMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        ContentClass cc = this.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException(this.getI18nString("errorContentClassNotExist", contentClassId));
        }
        ContentClassPartner ccp = this.getContentClassPartner(contentClassId, partnerId, false);
        if (ccp == null) {
            throw new ContentClassPersistenceException(this.getI18nString("errorUnableGetCcPartnerWithCcIdAndPartnerId", contentClassId, partnerId));
        }
        ccp.setContentClassType(cc.getType());
        ContentClassUIMerger merger = new ContentClassUIMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    @Transactional
    public void deleteContentClassesById(Collection<Long> ids) throws ContentClassPersistenceException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>();
        for (Long id : ids) {
            if (null == id) continue;
            this.doDeleteContentClassById(id);
            set.add(id);
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> set.forEach(this::syncAfterDelete));
    }

    @Transactional
    public void applyContentClassMetadataForIngest(Title title) throws ContentClassPersistenceException {
        ContentClass cc;
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            String msg = this.getI18nString("errorCcIdIsNull", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        String path = title.getAsset().getPath();
        if (path != null && "Series".equalsIgnoreCase(path) && (cc = this.getContentClassById(contentClassId)) != null && cc.getType() != ContentClass.Type.Series) {
            String msg = this.getI18nString("errorCanNotCreateSeriesTitleWithNonSeriesCc", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            String msg = this.getI18nString("errorPartnerIdIsNull", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        ContentClassPartner ccp = this.getMergedContentClassPartnerMetadataForIngest(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder();
        builder.applyMetadata(title, ccp);
    }

    @Transactional
    public void applyContentClassMetadataForView(Title title) throws ContentClassPersistenceException {
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            String msg = this.getI18nString("errorCcIdIsNull", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            String msg = this.getI18nString("errorPartnerIdIsNull", new Object[0]);
            throw new ContentClassPersistenceException(msg);
        }
        ContentClassPartner ccp = this.getMergedContentClassPartnerMetadataForView(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder(true);
        builder.applyMetadata(title, ccp);
    }

    public boolean contentClassNameExists(String name) throws ContentClassPersistenceException {
        if (null == name) {
            return false;
        }
        for (ContentClass cc : contentClassCache.values()) {
            if (!name.equals(cc.getName())) continue;
            return true;
        }
        return false;
    }

    @Transactional
    public boolean contentClassAssociatedWithTitle(long contentClassId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_title where content_class_id = ?1";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(1, (Object)contentClassId);
            query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    @Transactional
    public boolean contentClassPartnerExists(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ?1 and partner_id = ?2";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(1, (Object)contentClassId);
            query.setParameter(2, (Object)partnerId);
            query.addScalar("cnt", (Type)StandardBasicTypes.INTEGER);
            Integer count = this.parse(query.uniqueResult(), Integer.class);
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    @Transactional
    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long contentClassId, boolean isFetchMetadata, boolean isValidate) throws ContentClassPersistenceException {
        StringBuilder sql;
        if (isFetchMetadata) {
            sql = new StringBuilder(" select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid, ccp.data  from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc  where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?1 ");
        } else {
            sql = new StringBuilder(" select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid  from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc  where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?1 ");
            if (isValidate) {
                sql.append(" and ccp.data is not null ");
            }
        }
        List results = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            NativeQuery query = session.createSQLQuery(sql.toString());
            query.setParameter(1, (Object)contentClassId);
            results = query.list();
        }
        catch (HibernateException e) {
            String msg = "Unable to get content class partners with contentClassId = " + contentClassId;
            logger.error((Object)msg, (Throwable)e);
            msg = this.getI18nString("errorUnableGetCcPartnerWithCcId", contentClassId);
            throw new ContentClassPersistenceException(msg, (Throwable)e);
        }
        if (results == null || results.isEmpty()) {
            return new ArrayList<ContentClassPartner>();
        }
        ArrayList<ContentClassPartner> partners = new ArrayList<ContentClassPartner>();
        results.forEach(result -> {
            Object[] fields = this.parse(result, Object[].class);
            if (null == fields || fields.length < 5) {
                return;
            }
            ContentClassPartner ccp = new ContentClassPartner();
            ccp.setContentClassId(contentClassId);
            ccp.setContentClassName(this.parse(fields[0], String.class));
            BigDecimal bd = this.parse(fields[1], BigDecimal.class);
            if (bd != null) {
                ccp.setPartnerId(bd.longValue());
            }
            ccp.setPartnerName(this.parse(fields[2], String.class));
            ccp.setProviderId(this.parse(fields[3], String.class));
            if (isFetchMetadata) {
                ccp.setMetadata(this.fetchMetadata(this.parse(fields[4], String.class)));
            }
            partners.add(ccp);
        });
        return partners;
    }

    private ContentClassMetadata fetchMetadata(String xml) {
        if (null == xml) {
            return null;
        }
        ContentClassMetadata metadata = null;
        try {
            metadata = new ContentClassJaxbService().unmarshalContentClassMetadata(xml);
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)"Exception occurs when fetching metadata in ContentClassServiceHibernate#getContentClassPartnersByContentClassId", (Throwable)e);
        }
        return metadata;
    }

    public String marshalContentClass(ContentClass cc) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClass(cc, false);
    }

    public ContentClass unmarshalContentClass(String xml) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClass(xml);
    }

    public String marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClassWithPartners(cc, partners, false);
    }

    public ContentClass unmarshalContentClassWithPartners(String xml, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClassWithPartners(xml, partners);
    }

    @Transactional
    public Long getPartnerIdByName(String name) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id_ as id from pmm_partner where name = ?1 and isactive = 1";
            NativeQuery query = session.createSQLQuery(sql);
            query.addScalar("id", (Type)StandardBasicTypes.LONG);
            query.setParameter(1, (Object)name);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get partner id by name " + name;
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableGetPartnerIdByName", name);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public boolean isCategoryPackage(long titleId) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "SELECT content_class_id FROM pmm_title WHERE id_ = " + titleId;
            NativeQuery query = session.createSQLQuery(sql);
            Object result1 = query.uniqueResult();
            if (result1 == null) {
                String msg = this.getI18nString("errorNoRecordFoundForTitleId", titleId);
                throw new ContentClassPersistenceException(msg);
            }
            Long contentClassId1 = ((BigDecimal)result1).longValue();
            Long contentClassId2 = this.getCategoryContentClassId();
            return contentClassId1.longValue() == contentClassId2.longValue();
        }
        catch (ContentClassPersistenceException ccpe) {
            logger.error((Object)ERROR_MSG_DETERMINE_CATEGORY, (Throwable)ccpe);
            throw ccpe;
        }
        catch (Exception ex) {
            logger.error((Object)ERROR_MSG_DETERMINE_CATEGORY, (Throwable)ex);
            String msg = this.getI18nString("errorFailedToDetermineTitleIsCategoryPackage", new Object[0]);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private void publishNoficiationToHazelcast(long id, boolean isDelete) {
        if (0L == id) {
            return;
        }
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        ContentClassMessage msg = new ContentClassMessage(3, id, isDelete);
        topic.publish((Object)msg);
    }

    public void updateContentClassCache(long contentClassId, boolean isDelete) {
        contentClassCache.remove(contentClassId);
        if (!isDelete) {
            try {
                this.getContentClassById(contentClassId);
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)("Exception occurs when getting content class by id: " + contentClassId), (Throwable)e);
            }
        }
    }

    private <T> T parse(Object obj, Class<T> target) {
        if (null == obj) {
            return null;
        }
        if (this.canParse(obj, target)) {
            return (T)obj;
        }
        return null;
    }

    private boolean canParse(Object obj, Class<?> target) {
        for (boolean flag : this.getCheckResult(obj, target)) {
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private boolean[] getCheckResult(Object obj, Class<?> target) {
        return new boolean[]{target == String.class && obj instanceof String, target == Object[].class && obj instanceof Object[], target == BigDecimal.class && obj instanceof BigDecimal, target == Long.class && obj instanceof Long, target == Integer.class && obj instanceof Integer, target == Boolean.class && obj instanceof Boolean, target == Date.class && obj instanceof Date, target == ContentClassEntity.class && obj instanceof ContentClassEntity};
    }

    private void doDeleteContentClassById(long id) throws ContentClassPersistenceException {
        try {
            HibernateContext.getContext().getCurrentSession().createSQLQuery("delete from pmm_content_class where id = ?1").setParameter(1, (Object)id).executeUpdate();
        }
        catch (HibernateException ex) {
            String msg = "Unable to delete a content class with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            msg = this.getI18nString("errorUnableDeleteCc", id);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private void syncAfterDelete(long id) {
        contentClassCache.remove(id);
        this.publishNoficiationToHazelcast(id, true);
    }

    private void syncAfterSave(ContentClass contentClass) {
        contentClassCache.put(contentClass.getId(), contentClass);
        this.publishNoficiationToHazelcast(contentClass.getId(), false);
    }
}

