/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.image;

import com.tandbergtv.content.image.GenerateThumbnailResult;
import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGenerationException;
import com.tandbergtv.watchpoint.pmm.title.message.IThumbnailGeneratorProducer;
import com.tandbergtv.watchpoint.pmm.title.message.ResizeImageMsg;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ThumbnailGenerator
implements IThumbnailGenerator {
    private int preferredHeight;
    private int preferredWidth;
    private String outputFormat;
    private double minAdjustPercent = 0.1;
    private static final Logger logger = Logger.getLogger(ThumbnailGenerator.class);
    private static IThumbnailGeneratorProducer thumbnailGeneratorProducer;

    public ThumbnailGenerator(int preferredHeight, int preferredWidth, String outputFormat) {
        this.preferredHeight = preferredHeight;
        this.preferredWidth = preferredWidth;
        this.outputFormat = outputFormat;
    }

    public void generateThumbnail(InputStream imageStream, OutputStream thumbnailStream) throws ThumbnailGenerationException {
        this.generateThumbnail(imageStream, thumbnailStream, this.preferredHeight, this.preferredWidth);
    }

    public void generateTitleThumbnails(long titleId, List<GenerateThumbnailResult> generateThumbnailResults) {
        try {
            ResizeImageMsg msg = new ResizeImageMsg();
            HashMap<String, ResizeImageMsg.ImageProps> imageProps = new HashMap<String, ResizeImageMsg.ImageProps>(generateThumbnailResults.size());
            for (GenerateThumbnailResult generateThumbnailResult : generateThumbnailResults) {
                ResizeImageMsg.ImageProps props = new ResizeImageMsg.ImageProps();
                props.setAssetId(generateThumbnailResult.getAsset().getId());
                props.setType(generateThumbnailResult.getAsset().getType());
                props.setThumbnailPath(generateThumbnailResult.getThumbnailPath());
                props.setForceResize(true);
                imageProps.put(generateThumbnailResult.getOriginalPath(), props);
            }
            msg.setTitleId(titleId);
            msg.setImageProps(imageProps);
            msg.setPreferredHeight(this.preferredHeight);
            msg.setPreferredWidth(this.preferredWidth);
            ThumbnailGenerator.getThumbnailGeneratorProducer().sendThumbnailGeneratorMessage(msg);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to generate thumbnail, " + e.getMessage()));
        }
    }

    private static IThumbnailGeneratorProducer getThumbnailGeneratorProducer() {
        if (thumbnailGeneratorProducer == null) {
            thumbnailGeneratorProducer = (IThumbnailGeneratorProducer)ServiceRegistry.getDefault().lookup("thumbnail.generator.service");
        }
        return thumbnailGeneratorProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateThumbnail(InputStream imageStream, OutputStream thumbnailStream, int thumbnailHeight, int thumbnailWidth) throws ThumbnailGenerationException {
        BufferedImage image;
        try {
            image = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            String msg = "Failed to read the image from provided input stream, error: " + e.getLocalizedMessage();
            throw new ThumbnailGenerationException(msg, (Throwable)e);
        }
        if (image == null) {
            String msg = "Failed to read the image from provided input stream.";
            throw new ThumbnailGenerationException(msg);
        }
        BufferedImage thumbnail = new BufferedImage(thumbnailWidth, thumbnailHeight, 2);
        int imageHeight = image.getHeight(null);
        int imageWidth = image.getWidth(null);
        double imageRatio = (double)imageHeight / (double)imageWidth;
        double thumbnailRatio = (double)thumbnailHeight / (double)thumbnailWidth;
        int x = 0;
        int y = 0;
        int adjustedHeight = thumbnailHeight;
        int adjustedWidth = thumbnailWidth;
        if (imageRatio > thumbnailRatio) {
            int minAdjustedWidth;
            adjustedWidth = (int)Math.ceil((double)thumbnailHeight / imageRatio);
            if (adjustedWidth < (minAdjustedWidth = (int)Math.ceil(this.minAdjustPercent * (double)thumbnailWidth))) {
                adjustedWidth = minAdjustedWidth;
            }
            x = (thumbnailWidth - adjustedWidth) / 2;
        } else if (imageRatio < thumbnailRatio) {
            int minAdjustedHeight;
            adjustedHeight = (int)Math.ceil((double)thumbnailWidth * imageRatio);
            if (adjustedHeight < (minAdjustedHeight = (int)Math.ceil(this.minAdjustPercent * (double)thumbnailHeight))) {
                adjustedHeight = minAdjustedHeight;
            }
            y = (thumbnailHeight - adjustedHeight) / 2;
        }
        Graphics2D graphics = null;
        try {
            graphics = thumbnail.createGraphics();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, thumbnailWidth, thumbnailHeight);
            graphics.drawImage(image, x, y, adjustedWidth, adjustedHeight, null);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        try {
            if (!ImageIO.write((RenderedImage)thumbnail, this.outputFormat, thumbnailStream)) {
                String msg = "Failed to write the thumbnail to provided output stream.";
                throw new ThumbnailGenerationException(msg);
            }
        }
        catch (IOException e) {
            String msg = "Failed to write the thumbnail to the provided output stream, error: " + e.getLocalizedMessage();
            throw new ThumbnailGenerationException(msg, (Throwable)e);
        }
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }
}

