/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.lookupkey;

import com.tandbergtv.content.lookupkey.entities.LookupKey;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.content.lookupkey.service.LookupKeyValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class LookupKeyManager
implements ILookupKeyManager {
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("content");
    private static final int NAME_SIZE = 50;
    private static final int DESCRIPTION_SIZE = 255;

    public LookupKey get(long id) {
        Session session = this.getSession();
        return (LookupKey)session.load(LookupKey.class, (Serializable)Long.valueOf(id));
    }

    public LookupKey save(LookupKey lookupKey) throws LookupKeyValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(lookupKey.getName())) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyNameRequired"));
        } else if (lookupKey.getName().length() > 50) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyMaximuNameSize", new Object[]{50}));
        }
        if (this.isBlank(lookupKey.getDescription())) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyDescriptionRequired"));
        } else if (lookupKey.getDescription().length() > 255) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyMaximumDescriptionSize", new Object[]{255}));
        }
        LookupKey lookupKeyDB = this.getByName(lookupKey.getName());
        if (lookupKey.getId() == null && lookupKeyDB != null) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyNameMustBeUnique"));
        } else if (!(lookupKey.getId() == null || lookupKeyDB != null && lookupKey.getId().equals(lookupKeyDB.getId()))) {
            validationMessages.add(messageUtil.getMessageValue("errLookupKeyNameCanNotBeChanged"));
        }
        if (!validationMessages.isEmpty()) {
            throw new LookupKeyValidationException(validationMessages);
        }
        try {
            Session session = this.getSession();
            if (lookupKeyDB != null) {
                session.evict((Object)lookupKeyDB);
            }
            session.saveOrUpdate((Object)lookupKey);
            return lookupKey;
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Failed to save LookupKey: {0}", lookupKey), e);
        }
    }

    public List<LookupKey> getLookupKeys() {
        return this.getLookupKeys("name", true);
    }

    public List<LookupKey> getLookupKeys(String sortByProperty, boolean isAscending) {
        if (!"name".equalsIgnoreCase(sortByProperty) && !"description".equalsIgnoreCase(sortByProperty)) {
            throw new RuntimeException("Invalid sort property: " + sortByProperty);
        }
        Session session = this.getSession();
        String queryStr = "FROM com.tandbergtv.content.lookupkey.entities.LookupKey ORDER BY " + sortByProperty;
        queryStr = isAscending ? queryStr + " ASC" : queryStr + " DESC";
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<LookupKey> getLookupKeysByAssetType(String assetType) {
        Session session = this.getSession();
        String queryStr = "SELECT lk FROM com.tandbergtv.content.lookupkey.entities.LookupKey lk INNER JOIN lk.assetTypes AS at WHERE at = :asset_type";
        Query query = session.createQuery(queryStr);
        query.setParameter("asset_type", (Object)assetType);
        return query.list();
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private LookupKey getByName(String name) {
        String queryStr;
        LookupKey lookupKey = null;
        Session session = this.getSession();
        Query query = session.createQuery(queryStr = "SELECT lk FROM com.tandbergtv.content.lookupkey.entities.LookupKey lk WHERE lk.name = '" + name + "'");
        List lookupKeys = query.list();
        if (lookupKeys.size() == 1) {
            lookupKey = (LookupKey)lookupKeys.get(0);
        }
        return lookupKey;
    }

    public String getServiceName() {
        return "LookupKeyManagerService";
    }

    public void start() {
    }

    public void stop() {
    }

    public int delete(long lookupKeyId) throws LookupKeyValidationException {
        this.deleteLookupKeysAssetType(lookupKeyId);
        Session session = this.getSession();
        String queryStr = "DELETE FROM com.tandbergtv.content.lookupkey.entities.LookupKey WHERE id = :lookupkyeId";
        Query query = session.createQuery(queryStr);
        query.setParameter("lookupkyeId", (Object)lookupKeyId);
        int rowsAffected = query.executeUpdate();
        return rowsAffected;
    }

    private void deleteLookupKeysAssetType(long lookupKeyId) throws LookupKeyValidationException {
        Session session = this.getSession();
        String queryStr = "DELETE FROM cms_lookup_key_asset_type WHERE id_lookup_key = :lookupkyeId";
        NativeQuery query = session.createSQLQuery(queryStr);
        query.setParameter("lookupkyeId", (Object)lookupKeyId);
        query.executeUpdate();
    }
}

