/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CustomFieldDeleteCallback
implements ICustomFieldDeleteCallback {
    private static Logger logger = Logger.getLogger(CustomFieldDeleteCallback.class);
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("content");
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);

    public void beforeCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
        String msg;
        boolean exists;
        String assetPath = customField.getGroup().getAssetPath();
        String field = this.getFieldPath(customField);
        IElasticSearchService elasticSearchService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        SearchParameters params = new SearchParameters();
        if (assetPath.contains("PACKAGE")) {
            params.setTitleIndexType(ElasticSearchIndexType.MASTER);
        } else if (assetPath.contains("SERIES")) {
            params.setTitleIndexType(ElasticSearchIndexType.SERIES);
        } else {
            String msg2 = messageUtil.getMessageValue("errorCustomFieldCanNotBeDeleted1", new Object[]{customField.getName(), assetPath});
            throw new CustomFieldDeleteCallbackException(msg2);
        }
        params.setFields(new ArrayList<SearchParameters.FieldInfo>());
        params.setPageSize(1);
        ExpList condition1 = new ExpList();
        condition1.addItem((ExpNode)new ExpValue(new Predicate(field, assetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
        try {
            boolean bl = exists = !elasticSearchService.advancedSearchIds((ExpNode)condition1, params).isEmpty();
            if (!exists && assetPath.startsWith("PACKAGE/")) {
                String seriesAssetPath = assetPath.replace("PACKAGE", "SERIES");
                ExpList condition2 = new ExpList();
                params.setTitleIndexType(ElasticSearchIndexType.SERIES);
                condition2.addItem((ExpNode)new ExpValue(new Predicate(field, seriesAssetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
                boolean bl2 = exists = !elasticSearchService.advancedSearchIds((ExpNode)condition2, params).isEmpty();
            }
            if (!exists && ("PACKAGE/POSTER".equals(assetPath) || "PACKAGE/BOXCOVER".equals(assetPath))) {
                String seasonAssetPath = assetPath.replace("PACKAGE", "SERIES/SEASON");
                ExpList condition3 = new ExpList();
                condition3.addItem((ExpNode)new ExpValue(new Predicate(field, seasonAssetPath, FieldType.ASSET, LogicalOperator.ISEMPTY, Boolean.valueOf(true))));
                exists = !elasticSearchService.advancedSearchIds((ExpNode)condition3, params).isEmpty();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException(e.getMessage(), e);
        }
        if (exists) {
            msg = messageUtil.getMessageValue("errorCustomFieldCanNotBeDeleted2", new Object[]{customField.getName(), assetPath});
            throw new CustomFieldDeleteCallbackException(msg);
        }
        if (this.ruleManager.isFieldUsedInRules(field)) {
            msg = messageUtil.getMessageValue("errorCustomFieldCanNotBeDeleted3", new Object[]{customField.getName(), assetPath});
            throw new CustomFieldDeleteCallbackException(msg);
        }
    }

    public void afterCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
    }

    private String getFieldPath(CustomField customField) {
        return "/Fields/CustomFields/CustomField[@name=" + customField.getName() + "]/@value";
    }

    public void afterCustomFieldGroupDelete(CustomFieldGroup customFieldGroup) throws CustomFieldDeleteCallbackException {
    }
}

