/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.metadata;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalRegister;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.enums.CustomFieldOptionsEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.DistributedTitleMessage;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class CustomFieldManager
implements ICustomFieldManager {
    private static Logger logger = Logger.getLogger(CustomFieldManager.class);

    public String getServiceName() {
        return "CustomFieldManager";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public List<CustomFieldGroup> getAllGroups() {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        return dao.getAllGroups();
    }

    public void saveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        this.onlySaveGroups(groupList);
        this.updateUISpec();
    }

    @Transactional
    private void onlySaveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        List allGroups = dao.getAllGroups();
        List<CustomFieldGroup> deletedGroups = this.getDeletedGroups(allGroups, groupList);
        try {
            dao.saveGroups(groupList);
        }
        catch (CustomFieldDeleteCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
        }
        if (!CollectionUtils.isEmpty(deletedGroups)) {
            try {
                dao.deleteCustomFieldGroups(deletedGroups);
            }
            catch (CustomFieldDeleteCallbackException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CustomFieldDeleteCallbackException("save error: " + e.getMessage());
            }
        }
    }

    @Transactional
    private void updateUISpec() {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        this.updateUISpecCache(dao.getAllGroups());
    }

    @Transactional
    public Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> getAllCustomFieldsForUISpec() {
        List<CustomFieldGroup> groups = this.getAllGroups();
        return CustomFieldManager.createCustomFieldMap(groups);
    }

    public static Map<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> createCustomFieldMap(List<CustomFieldGroup> groups) {
        HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>> map = new HashMap<String, List<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>>();
        if (groups == null) {
            return map;
        }
        for (CustomFieldGroup group : groups) {
            String path = group.getAssetPath();
            ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup> newList = (ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>)map.get(path);
            if (newList == null) {
                newList = new ArrayList<com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup>();
                map.put(path, newList);
            }
            com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup newGroup = new com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup(group.getUuid(), group.getDisplayName());
            List list = group.getCustomFieldList();
            if (list != null) {
                for (CustomField cf : list) {
                    com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = CustomFieldManager.createCf(cf);
                    newGroup.fields.add(newCf);
                }
            }
            newList.add(newGroup);
        }
        return map;
    }

    private static com.tandbergtv.watchpoint.pmm.title.conf.CustomField createCf(CustomField cf) {
        com.tandbergtv.watchpoint.pmm.title.conf.CustomField newCf = new com.tandbergtv.watchpoint.pmm.title.conf.CustomField();
        String type = cf.getDataType();
        if ("Boolean".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.BOOLEAN;
        } else if ("Date".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.DATE;
        } else if ("Float".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.FLOAT;
        } else if ("Integer".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.INTEGER;
        } else if ("String".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.STRING;
            if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_AREA) {
                newCf.multiLine = true;
            }
        } else if ("Time".equalsIgnoreCase(type)) {
            newCf.dataType = CustomField.DataType.TIME;
        } else {
            throw new RuntimeException("Invalid data type " + type);
        }
        newCf.displayName = cf.getDisplayName();
        newCf.name = cf.getName();
        newCf.groupId = cf.getGroup().getUuid();
        if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.TEXT_BOX) {
            newCf.dropDown = false;
            newCf.anyValueAllowed = false;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.DROP_DOWN) {
            newCf.anyValueAllowed = false;
            newCf.dropDown = true;
        } else if (CustomFieldOptionsEnum.fromId((int)cf.getFieldType()) == CustomFieldOptionsEnum.COMBO_BOX) {
            newCf.dropDown = true;
            newCf.anyValueAllowed = true;
        }
        newCf.multiValue = CustomFieldManager.toBoolean(cf.getMultiValue());
        newCf.jobParameter = CustomFieldManager.toBoolean(cf.getJobParameter());
        newCf.jobScheduleParameter = CustomFieldManager.toBoolean(cf.getJobScheduleParameter());
        return newCf;
    }

    private static boolean toBoolean(String str) {
        return "Y".equalsIgnoreCase(str);
    }

    public boolean isValidField(String name, String displayName, String path, String groupDisplayName) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        return dao.validField(name, displayName, path, groupDisplayName);
    }

    @Transactional
    public void deleteCustomField(CustomField field) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomField(field);
    }

    @Transactional
    public void deleteCustomFieldGroup(CustomFieldGroup group) {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        dao.deleteCustomFieldGroup(group);
    }

    private List<CustomFieldGroup> getDeletedGroups(List<CustomFieldGroup> allGroups, List<CustomFieldGroup> groupList) {
        ArrayList<CustomFieldGroup> deletedGroups = new ArrayList<CustomFieldGroup>();
        for (CustomFieldGroup oldGroup : allGroups) {
            if (groupList.contains(oldGroup)) continue;
            deletedGroups.add(oldGroup);
        }
        return deletedGroups;
    }

    public void deleteCustomFieldGroups(List<CustomFieldGroup> groupList) {
    }

    @Transactional
    public int saveImportedCustomFields(List<CustomFieldGroup> groupList) throws Exception {
        ICustomFieldPersistenceService dao = CustomFieldPersistenceService.getInstance();
        int isError = dao.saveImportedCustomFields(groupList);
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.updateUISpecCache(dao.getAllGroups()));
        return isError;
    }

    private void updateUISpecCache(List<CustomFieldGroup> groups) {
        DataTypeMappingReader dt = DataTypeMappingReader.getInstance(null, null);
        dt.refreshCustomFieldDataTypeMap(groups);
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        sm.updateUISpecifications(CustomFieldManager.createCustomFieldMap(groups));
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        DistributedTitleMessage msg = new DistributedTitleMessage(1);
        topic.publish((Object)msg);
    }
}

