/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.communication;

import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class Util {
    private static final String ZERO = "0";

    private Util() {
    }

    public static String getStringValueTrimmed(WorkflowMessage message, String paramName) {
        String value;
        String string = value = message.getPayload() != null ? message.getValue(paramName) : null;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public static Long getLongValue(WorkflowMessage message, String paramName) {
        String value = Util.getStringValueTrimmed(message, paramName);
        return value != null ? Long.valueOf(value) : null;
    }

    public static boolean getBooleanValue(WorkflowMessage message, String paramName) {
        String value = Util.getStringValueTrimmed(message, paramName);
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    public static Long convertZeroOrLessToNull(Long l) {
        return l == null || l < 1L ? null : l;
    }

    public static String convertNullToZero(Long l) {
        return l == null ? ZERO : String.valueOf(l);
    }

    public static void validateRequired(WorkflowMessage message, String ... paramNames) {
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (Util.getStringValueTrimmed(message, paramName) != null) continue;
                throw new RuntimeException("Parameter " + paramName + " is not found or does not have value");
            }
        }
    }

    public static void validateAtLeastOneRequired(WorkflowMessage message, String ... paramNames) {
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (Util.getStringValueTrimmed(message, paramName) == null) continue;
                return;
            }
            throw new RuntimeException("Parameters " + paramNames + " must have at least one non-empty value");
        }
    }

    public static String getCommaSeparatedList(Collection<?> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null) {
            boolean firstTime = true;
            for (Object object : collection) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(object.toString());
            }
        }
        return sb.toString();
    }

    public static void validateMetadataDateField(WorkflowMessage message, String fieldXpath, String assetTypeParam, String fieldValueParam) {
        if (fieldXpath != null && !fieldXpath.isEmpty()) {
            String fieldValue = Util.getStringValueTrimmed(message, fieldValueParam);
            if (fieldValue == null || fieldXpath.isEmpty()) {
                throw new RuntimeException("There is no field value for  " + fieldValueParam);
            }
            String dataType = DataTypeMappingReader.getInstance().determineDataType(fieldXpath);
            if (dataType != null && "date".equals(dataType)) {
                SimpleDateFormat formatIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                try {
                    formatIn.parse(fieldValue);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Invalid date format for " + fieldValueParam);
                }
            }
        }
    }
}

