/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;

public class RegisterFileMessageHandler
implements MessageHandler {
    private static final String LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String MATERIAL_ID_XPATH = "/Fields/CustomFields/CustomField[@name=MaterialId]/@value";
    private static final String ENCODE_PROFILE_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeProfile]/@value";
    private static final String ENCODE_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String FILE_SIZE = "fileSize";
    private static final String MIME_TYPE = "mimeType";
    private static final String FILE_NAME = "fileName";
    private static final String DURATION = "duration";
    private static final String ASPECTRATIO = "aspectratio";
    private static final String BITRATE = "bitrate";
    private static final String RESOLUTION = "resolution";
    private static final String MATERIAL_ID = "materialId";
    private static final String ENCODE_PROFILE = "encodeProfile";
    private static final String ENCODE_FORMAT = "encodeFormat";
    private static final String ORIGINAL_FILE_PATH = "originalFilePath";
    private static final String TITLE_ID = "titleId";
    private static final String FILE_URI = "fileURI";
    private static final String ASSET_ID = "assetId";
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";
    private static final String LOOKUP_KEY = "lookupKey";
    private static final String CHECKSUM = "checksum";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, TITLE_ID, FILE_URI, ASSET_ID);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        String fileURI = Util.getStringValueTrimmed(message, FILE_URI);
        Long assetId = Util.getLongValue(message, ASSET_ID);
        String originalFilePath = Util.getStringValueTrimmed(message, ORIGINAL_FILE_PATH);
        String encodeFormat = Util.getStringValueTrimmed(message, ENCODE_FORMAT);
        String encodeProfile = Util.getStringValueTrimmed(message, ENCODE_PROFILE);
        String materialId = Util.getStringValueTrimmed(message, MATERIAL_ID);
        String lookupKey = Util.getStringValueTrimmed(message, LOOKUP_KEY);
        String resolution = Util.getStringValueTrimmed(message, RESOLUTION);
        String bitrate = Util.getStringValueTrimmed(message, BITRATE);
        String aspectratio = Util.getStringValueTrimmed(message, ASPECTRATIO);
        String duration = Util.getStringValueTrimmed(message, DURATION);
        String fileName = Util.getStringValueTrimmed(message, FILE_NAME);
        String mimeType = Util.getStringValueTrimmed(message, MIME_TYPE);
        String fileSize = Util.getStringValueTrimmed(message, FILE_SIZE);
        String width = Util.getStringValueTrimmed(message, WIDTH);
        String height = Util.getStringValueTrimmed(message, HEIGHT);
        String sourceComponentName = Util.getStringValueTrimmed(message, "sourceComponentName");
        String sourceEntityName = Util.getStringValueTrimmed(message, "sourceEntityName");
        String sourceId = Util.getStringValueTrimmed(message, "sourceId");
        String checksum = Util.getStringValueTrimmed(message, CHECKSUM);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleManager service = (ITitleManager)registry.lookup(ITitleManager.class);
        Title title = null;
        try {
            title = service.getForUpdate(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset targetAsset = null;
        for (Asset asset : groupAsset.getAllAssets(false)) {
            if (asset.getId() != assetId.longValue()) continue;
            targetAsset = asset;
            break;
        }
        if (targetAsset == null) {
            String msg = "Did not get an item object for a given assetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        if (lookupKey != null && !lookupKey.equals("")) {
            for (com.tandbergtv.metadatamanager.model.File file : targetAsset.getDirectDescendantFiles()) {
                Field lookupKeyField = file.getFirstField(LOOKUP_KEY_XPATH);
                if (lookupKeyField == null || !lookupKeyField.getTypedValue().equals(lookupKey)) continue;
                lookupKeyField.setValue("");
            }
        }
        com.tandbergtv.metadatamanager.model.File derivedFile = new com.tandbergtv.metadatamanager.model.File();
        derivedFile.setFileType(FileType.DERIVED);
        this.addField(derivedFile, FieldName.FILE_URL.toString(), fileURI);
        this.addField(derivedFile, ENCODE_FORMAT_XPATH, encodeFormat);
        this.addField(derivedFile, ENCODE_PROFILE_XPATH, encodeProfile);
        this.addField(derivedFile, MATERIAL_ID_XPATH, materialId);
        this.addField(derivedFile, LOOKUP_KEY_XPATH, lookupKey);
        this.addField(derivedFile, FieldName.RESOLUTION.toString(), resolution);
        this.addField(derivedFile, FieldName.BITRATE.toString(), bitrate);
        this.addField(derivedFile, FieldName.ASPECTRATIO.toString(), aspectratio);
        this.addField(derivedFile, FieldName.DURATION.toString(), duration);
        this.addField(derivedFile, FieldName.FILE_NAME.toString(), fileName);
        this.addField(derivedFile, FieldName.MIME_TYPE.toString(), mimeType);
        if (fileSize == null || fileSize.equals("")) {
            fileSize = new File(fileURI).length() + "";
        }
        this.addField(derivedFile, FieldName.FILE_SIZE.toString(), fileSize);
        this.addField(derivedFile, FieldName.WIDTH.toString(), width);
        this.addField(derivedFile, FieldName.HEIGHT.toString(), height);
        this.addField(derivedFile, FieldName.FILE_CHECKSUM.toString(), checksum);
        if (originalFilePath != null) {
            com.tandbergtv.metadatamanager.model.File targetFile = null;
            for (com.tandbergtv.metadatamanager.model.File file : targetAsset.getDirectDescendantFiles()) {
                if (!file.getURL().equals(originalFilePath)) continue;
                targetFile = file;
                break;
            }
            if (targetFile == null) {
                String msg = "Did not find a file object for a given assetId and originalFilePath.";
                throw new MessageHandlerException("ERR-003", msg);
            }
            targetFile.addChild((Asset)derivedFile);
        } else {
            targetAsset.addChild((Asset)derivedFile);
        }
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        service.update(title, false, (ITitleActionSource)source);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(RESULT, SUCCESS);
        return response;
    }

    private void addField(com.tandbergtv.metadatamanager.model.File derivedFile, String path, String value) {
        if (value != null && path != null && !path.trim().isEmpty()) {
            derivedFile.addField(new Field(path, value));
        }
    }
}

