/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.ericsson.cms.content.util.ContentServerException;
import com.ericsson.cms.content.util.ContentServerUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;

public class AssetsManager {
    private static final Logger logger = Logger.getLogger(AssetsManager.class);
    private static final String UNMAPPED_FILES_DIR = "unmappedAssets";
    private static final String MAPPED_FILES_DIR = "mappedAssets";
    private static final String DERIVED_FILES_DIR = "derivedAssets";
    private String unmappedFilesDirectory;
    private String mappedFilesDirectory;
    private String derivedFilesDirectory;
    private static ThreadLocal<AssetsManager> instances = new ThreadLocal();
    private Map<String, String> mappedFiles = new HashMap<String, String>();
    private Queue<Record> records = new LinkedList<Record>();

    private AssetsManager() {
    }

    public static AssetsManager getThreadLocalInstance() {
        AssetsManager instance = instances.get();
        if (instance == null) {
            instance = new AssetsManager();
            instances.set(instance);
        }
        return instance;
    }

    public String getUnmappedFilesDirectory() {
        if (this.unmappedFilesDirectory == null) {
            this.unmappedFilesDirectory = PMMProperties.getInstance().getProperty(UNMAPPED_FILES_DIR);
            AssetsManager.validateConfigurationDirectory(this.unmappedFilesDirectory, UNMAPPED_FILES_DIR);
        }
        return this.unmappedFilesDirectory;
    }

    public String getMappedFilesDirectory() {
        if (this.mappedFilesDirectory == null) {
            this.mappedFilesDirectory = PMMProperties.getInstance().getProperty(MAPPED_FILES_DIR);
            AssetsManager.validateConfigurationDirectory(this.mappedFilesDirectory, MAPPED_FILES_DIR);
        }
        return this.mappedFilesDirectory;
    }

    public String getDerivedFilesDirectory() {
        if (this.derivedFilesDirectory == null) {
            this.derivedFilesDirectory = PMMProperties.getInstance().getProperty(DERIVED_FILES_DIR);
            AssetsManager.validateConfigurationDirectory(this.derivedFilesDirectory, DERIVED_FILES_DIR);
        }
        return this.derivedFilesDirectory;
    }

    public List<String> getUnmappedFiles() throws IOException {
        return this.getAllFiles(this.getUnmappedFilesDirectory());
    }

    public List<String> getUnmappedFiles(String fileName, String pathFilter) throws IOException {
        return this.getFiles(this.getUnmappedFilesDirectory(), fileName, pathFilter);
    }

    public boolean isUnmappedFile(String filePath) {
        return this.isValidFile(filePath, this.getUnmappedFilesDirectory());
    }

    public boolean isUnmappedFilePath(String filePath) {
        String unmappedPath = this.getUnmappedFilesDirectory();
        return filePath != null && filePath.startsWith(unmappedPath);
    }

    public boolean isMappedFile(String filePath) {
        return this.isValidFile(filePath, this.getMappedFilesDirectory());
    }

    private boolean isValidFile(String filePath, String parentFolder) {
        if (filePath != null && filePath.startsWith(parentFolder)) {
            return !ContentServerUtil.isDirectory(filePath);
        }
        return false;
    }

    public String moveToMappedFilesDirectory(String filePath) throws IOException {
        String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
        String targetDirName = fileName + "_" + System.currentTimeMillis();
        String targetFilePath = Paths.get(this.getMappedFilesDirectory(), targetDirName, fileName).toString();
        this.recordMove(filePath, targetFilePath);
        return targetFilePath;
    }

    public String moveToUnmappedFilesDirectory(String filePath, String dirName) throws IOException {
        String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
        String targetDirName = dirName + File.separator + fileName + "_" + System.currentTimeMillis();
        String targetFile = Paths.get(this.getUnmappedFilesDirectory(), targetDirName, fileName).toString();
        this.recordMove(filePath, targetFile);
        return targetFile;
    }

    public void beginTransaction() {
        logger.debug((Object)"Begining transaction");
        this.records.clear();
        this.mappedFiles.clear();
    }

    public void commitTransaction() {
        logger.debug((Object)"Committing transaction.");
        ArrayList<String> srcs = new ArrayList<String>();
        ArrayList<String> dests = new ArrayList<String>();
        Record r = this.records.poll();
        while (r != null) {
            srcs.add(r.src);
            dests.add(r.dest);
            r = this.records.poll();
        }
        try {
            ContentServerUtil.createFoldersAndMoveFiles(srcs, dests);
        }
        catch (Exception e) {
            throw new RuntimeException("File batch move failed with source : " + srcs + " and destinations : " + dests + " : " + e.getLocalizedMessage(), e);
        }
        finally {
            this.records.clear();
        }
    }

    public void rollbackTransaction() {
        logger.debug((Object)"Rolling back transaction.");
        this.records.clear();
        this.mappedFiles.clear();
    }

    public String getSourceFile(String destFile) {
        return this.mappedFiles.get(destFile);
    }

    private void recordMove(String src, String dest) {
        this.mappedFiles.put(dest, src);
        this.records.add(new Record(src, dest));
    }

    private List<String> getAllFiles(String folder) throws IOException {
        try {
            return ContentServerUtil.getFilePaths(folder);
        }
        catch (ContentServerException e) {
            logger.error((Object)("fail to get the list of files for directory : " + folder), (Throwable)e);
            throw new IOException("fail to get the list of files for directory : " + folder);
        }
    }

    private List<String> getFiles(String dirFile, String fileName, String pathFilter) throws IOException {
        List<String> paths = this.getAllFiles(dirFile);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String path : paths) {
            if (pathFilter == null || !TitleUtil.checkContainsWithNeptuneSetting(path, pathFilter) || !TitleUtil.compareFileNames(Paths.get(path, new String[0]).getFileName().toString(), fileName)) continue;
            fileList.add(path);
        }
        return fileList;
    }

    public String getDerivedFilesDirectory(Title title) {
        if (title.getId() == null) {
            throw new RuntimeException("The title cannot have a derived folder location since it is not persisted.");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IPartnerManagement partnerManager = (IPartnerManagement)registry.lookup(IPartnerManagement.class);
        String providerId = partnerManager.getPartner(title.getPartnerId().longValue()).getProviderId();
        return Paths.get(this.getDerivedFilesDirectory(), providerId, title.getId().toString()).toString();
    }

    private static void validateConfigurationDirectory(String path, String configName) {
        try {
            if (!ContentServerUtil.isDirectory(path)) {
                AssetsManager.logErrorConfiguration(path, configName, null);
            }
        }
        catch (ContentServerException e) {
            AssetsManager.logErrorConfiguration(path, configName, e);
        }
    }

    private static void logErrorConfiguration(String path, String configName, Exception e) {
        logger.error((Object)("[Configuration Error] " + configName + " " + path + " does not exist"), (Throwable)e);
    }

    private static class Record {
        private String src;
        private String dest;

        Record(String src, String dest) {
            this.src = src;
            this.dest = dest;
        }

        public String toString() {
            return "Source: " + this.src + " | Destination: " + this.dest;
        }
    }
}

