/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.ericsson.cms.content.util.ContentServerException;
import com.ericsson.cms.content.util.ContentServerUtil;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.FatalTitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMUtil;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.NormalizationContextEvent;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.NormalizedItem;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PMMUIService
implements IPMMUIService {
    private static final String UNMAPPED_ASSETS = "unmappedAssets";
    private static final Logger logger = Logger.getLogger(PMMUIService.class);
    private ITitleManager titleManager;
    private ITitleStatusService statusService;
    private ITitleSearchService titleSearchService;
    private static final String ACTION_MAP_ASSET = "MAP_ASSET";

    public String getServiceName() {
        return "PMM UI Service";
    }

    public void start() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        this.titleManager = (ITitleManager)registry.lookup(ITitleManager.class);
        this.titleSearchService = (ITitleSearchService)registry.lookup(ITitleSearchService.class);
        this.statusService = new TitleStatusService();
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public SaveResult createTitle(Title title, String sourceComponentName, String sourceEntityName, String sourceId, String meRequestKey) throws TitleValidationException {
        this.checkLicense(title.getContentClassId());
        boolean success = false;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        try {
            NormalizedItem normalizedItem = this.nationalizeTitle(title, NormalizationContextEvent.UICREATED, meRequestKey);
            Title normedTitle = normalizedItem.getTitle();
            this.moveFilesToMappedFilesDir(normedTitle);
            Map<File, Asset> fileToAssetMap = this.getNewlyAddedFiles(normedTitle.getAsset(), null);
            TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
            ISavedTitle savedTitle = null;
            try {
                savedTitle = this.titleManager.create(normedTitle, false, (ITitleActionSource)source);
                normedTitle = savedTitle.getTitle();
            }
            catch (TitleValidationException e) {
                logger.error((Object)"Exception: ", (Throwable)e);
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            this.statusService.sendStatus(normedTitle, "NORMALIZED", normalizedItem.getNormalizationChangeInfo(), true, sourceComponentName, sourceEntityName, sourceId);
            this.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, normedTitle, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendUICreatedEvent(normedTitle);
            success = true;
            SaveResult saveResult = new SaveResult(normedTitle, savedTitle.getValidationMessages());
            return saveResult;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
    }

    private SaveResult updateTitle(Title title, boolean draft, String sourceComponentName, String sourceEntityName, String sourceId, String meRequestId) throws TitleValidationException {
        Asset assetForSave = title.getAsset();
        title = this.titleManager.get(title.getId());
        Asset existingAsset = title.getAsset();
        if (!assetForSave.getVersion().equals(existingAsset.getVersion())) {
            ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
            String msg = "Unable to update the title. The revision you are trying to update is not the latest. Please refresh the page and try again.";
            String code = "TITLE_COPY_BAD_VERSION_MISMATCH";
            TitleValidationMessage message = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)code, (String)msg);
            messages.add(message);
            throw new TitleValidationException(messages);
        }
        title.setAsset(assetForSave);
        NormalizedItem normalizedItem = new NormalizedItem(title);
        if (!draft) {
            normalizedItem = this.nationalizeTitle(title, NormalizationContextEvent.UIUPDATED, meRequestId);
            title = normalizedItem.getTitle();
        }
        List validationMessages = null;
        try {
            validationMessages = this.titleManager.validate(title, draft);
        }
        catch (TitleValidationException e) {
            if (!draft) {
                String code = "PMMUI-001";
                String message = "Title made invalid after applying nationalization rules.";
                throw new FatalTitleValidationException(code, message, e.getMessages());
            }
            throw e;
        }
        Map<String, List<File>> filePathMap = this.getFilePathMap(title);
        this.validateFilePaths(title, filePathMap);
        this.unmapFiles(title, existingAsset, filePathMap);
        Map<File, Asset> fileToAssetMap = this.getNewlyAddedFiles(title.getAsset(), existingAsset);
        this.moveFilesToMappedFilesDir(title);
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.update(title, draft, (ITitleActionSource)source);
        title = savedTitle.getTitle();
        if (!draft) {
            this.statusService.sendStatus(title, "NORMALIZED", normalizedItem.getNormalizationChangeInfo(), true, sourceComponentName, sourceEntityName, sourceId);
        }
        this.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
        if (!draft) {
            RulesEngineFacade.sendUIUpdatedEvent(title);
        }
        return new SaveResult(title, validationMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public SaveResult updateTitleMetadata(Title title, Long requestKey, String action, String listOfAssetIds, String sourceComponentName, String sourceEntityName, String sourceId, String meRequestKey) throws TitleValidationException {
        SaveResult result = null;
        boolean success = false;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        try {
            result = this.updateTitle(title, false, sourceComponentName, sourceEntityName, sourceId, meRequestKey);
            if (requestKey != null && action.equals(ACTION_MAP_ASSET)) {
                ArrayList<Long> requestedAssetIds = new ArrayList<Long>();
                for (String assetIdStr : listOfAssetIds.split(",")) {
                    requestedAssetIds.add(Long.valueOf(assetIdStr.trim()));
                }
                ArrayList<Object> requestedAssetsWithOriginalFile = new ArrayList<Object>();
                ArrayList<Object> requestedAssetsWithoutOriginalFile = new ArrayList<Object>();
                ArrayList<File> fileAssets = new ArrayList<File>();
                for (Long requestedAssetId : requestedAssetIds) {
                    Asset requestedAsset = this.getAssetWithId(title, requestedAssetId);
                    File file = this.getOriginalFile(requestedAsset);
                    if (file != null) {
                        requestedAssetsWithOriginalFile.add(requestedAsset);
                        fileAssets.add(file);
                        continue;
                    }
                    requestedAssetsWithoutOriginalFile.add(requestedAsset);
                }
                if (requestedAssetsWithOriginalFile.size() == requestedAssetIds.size()) {
                    WorkflowNotifier wnThread = new WorkflowNotifier(requestKey, fileAssets);
                    wnThread.start();
                } else {
                    StringBuffer assetTypesSB = new StringBuffer();
                    boolean firstTime = true;
                    for (Asset asset : requestedAssetsWithoutOriginalFile) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            assetTypesSB.append(", ");
                        }
                        assetTypesSB.append(asset.getAssetType());
                    }
                    HashMap<String, String> actionResponseMap = new HashMap<String, String>();
                    actionResponseMap.put(UNMAPPED_ASSETS, assetTypesSB.toString());
                    result.setActionResponseMap(actionResponseMap);
                }
            }
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return result;
    }

    private NormalizedItem nationalizeTitle(Title title, NormalizationContextEvent eventType, String meRequestId) throws TitleValidationException {
        this.titleManager.validate(title, false);
        return this.titleManager.normalizeTitleWithMetadataEnhancement(title, eventType.getName(), meRequestId);
    }

    private void validateFilePaths(Title title, Map<String, List<File>> filePathMap) throws TitleValidationException {
        if (title.isCopy()) {
            int fileCount = 0;
            for (String filePath : filePathMap.keySet()) {
                if (!AssetsManager.getThreadLocalInstance().isUnmappedFilePath(filePath)) continue;
                ++fileCount;
            }
            if (fileCount > 0) {
                ArrayList<TitleValidationMessage> messages = new ArrayList<TitleValidationMessage>();
                String msg = "The copied title contains " + fileCount + " file(s) with URLs that refers to the unmapped folder location. Copied title files cannot refer to the unmapped folder location.";
                String code = "TITLE_COPY_BAD_FILE_URL";
                TitleValidationMessage message = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)code, (String)msg);
                messages.add(message);
                throw new TitleValidationException(messages);
            }
        }
    }

    private void unmapFiles(Title title, Asset existingAsset, Map<String, List<File>> filePathMap) {
        if (title.isCopy()) {
            return;
        }
        ArrayList<String> unmappedFileURLs = new ArrayList<String>();
        List<File> filesToUnmap = this.getDifferenceInFiles(existingAsset, title.getAsset());
        Iterator<File> filesToUnmapIterator = filesToUnmap.iterator();
        while (filesToUnmapIterator.hasNext()) {
            File fileToUnmap = filesToUnmapIterator.next();
            String fileURL = fileToUnmap.getURL();
            boolean unmapFile = true;
            List<File> matchingURLFiles = filePathMap.get(fileURL);
            if (matchingURLFiles != null && matchingURLFiles.isEmpty()) {
                unmapFile = false;
            } else if (!AssetsManager.getThreadLocalInstance().isMappedFile(fileURL)) {
                unmapFile = false;
            } else if (unmappedFileURLs.contains(fileURL)) {
                unmapFile = false;
            } else if (this.isSharedFilePath(title, fileURL)) {
                unmapFile = false;
            }
            if (!unmapFile) {
                filesToUnmapIterator.remove();
                continue;
            }
            unmappedFileURLs.add(fileURL);
        }
        String dirName = PMMUtil.getPathFilterFieldValue(title.getAsset());
        this.moveToUnmappedFilesDir(filesToUnmap, dirName);
    }

    private Map<String, List<File>> getFilePathMap(Title title) {
        HashMap<String, List<File>> filePathMap = new HashMap<String, List<File>>();
        List files = title.getAsset().getAllDescendantFiles();
        for (File file : files) {
            String url = file.getURL();
            ArrayList<File> filesForURL = (ArrayList<File>)filePathMap.get(url);
            if (filesForURL == null) {
                filesForURL = new ArrayList<File>();
                filePathMap.put(url, filesForURL);
            }
            filesForURL.add(file);
        }
        return filePathMap;
    }

    private boolean isSharedFilePath(Title title, String fileURL) {
        return this.titleSearchService.isSharedFilePathAllcopies(fileURL, title.getId(), null);
    }

    private Asset getAssetWithId(Title title, long id) {
        return this.findMatchingAsset(id, title.getAllAssets(false));
    }

    private File getOriginalFile(Asset asset) {
        for (File file : asset.getDirectDescendantFiles()) {
            if (!file.isOriginal()) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Title createTitleAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        this.checkLicense(title.getContentClassId());
        boolean success = false;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        try {
            this.moveFilesToMappedFilesDir(title);
            Map<File, Asset> fileToAssetMap = this.getNewlyAddedFiles(title.getAsset(), null);
            TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
            this.titleManager.create(title, true, (ITitleActionSource)source);
            this.sendProgressStatusForManuallyMappedFiles(fileToAssetMap, title, sourceComponentName, sourceEntityName, sourceId);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return title;
    }

    @Transactional
    public void batchUpdateTitleMetadata(Title updates, List<Long> titleIds, boolean currentState, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        for (Long titleId : titleIds) {
            Title title = this.titleManager.getForUpdate(titleId);
            Asset gotAsset = title.getAsset();
            this.batchMerge(updates.getAsset(), gotAsset);
            boolean draft = currentState ? TitleStatus.DRAFT.equals((Object)title.getStatus()) : TitleStatus.DRAFT.equals((Object)updates.getStatus());
            if (draft) {
                this.updateTitleMetadataAsDraft(title, sourceComponentName, sourceEntityName, sourceId);
                continue;
            }
            this.updateTitleMetadata(title, null, null, null, sourceComponentName, sourceEntityName, sourceId, null);
        }
    }

    private void batchMerge(Asset updates, Asset asset) {
        for (Field fieldUpdate : updates.getFields()) {
            boolean nullify = fieldUpdate.isNullify();
            String xpath = fieldUpdate.getTtvXPath();
            if (nullify) {
                Iterator fieldIterator = asset.getFields().iterator();
                while (fieldIterator.hasNext()) {
                    Field assetField = (Field)fieldIterator.next();
                    if (!assetField.getTtvXPath().equals(xpath)) continue;
                    fieldIterator.remove();
                }
                continue;
            }
            Field assetField = asset.getField(xpath);
            if (assetField == null) {
                int indexCount = xpath.replaceAll("[^/]", "").length();
                if (xpath.contains("/@")) {
                    --indexCount;
                }
                Field f = new Field(xpath, fieldUpdate.getValue());
                List indices = f.getIndices();
                for (int i = 0; i < indexCount; ++i) {
                    indices.add(1);
                }
                asset.addField(f);
                continue;
            }
            assetField.setTypedValue(fieldUpdate.getTypedValue());
        }
        if ("PACKAGE".equals(updates.getAssetType())) {
            Asset target = null;
            List relations = updates.getRelations();
            if (relations != null) {
                for (Relation relation : relations) {
                    if (!"TITLE".equals(relation.getTargetAsset().getAssetType())) continue;
                    target = relation.getTargetAsset();
                    break;
                }
            }
            if (target != null) {
                for (Relation assetRelation : asset.getRelations()) {
                    Asset targetAsset = assetRelation.getTargetAsset();
                    if (!targetAsset.getAssetType().equals("TITLE")) continue;
                    this.batchMerge(target, targetAsset);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Title updateTitleMetadataAsDraft(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        SaveResult result = null;
        boolean success = false;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        try {
            result = this.updateTitle(title, true, sourceComponentName, sourceEntityName, sourceId, null);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        return result.getTitle();
    }

    private List<File> getDifferenceInFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<File> resultFiles = new ArrayList<File>();
        List<Asset> firstTree = this.getAssets(firstAsset);
        List<Asset> secondTree = this.getAssets(secondAsset);
        for (Asset firstTreeAsset : firstTree) {
            Asset secondTreeAsset = this.findMatchingAsset(firstTreeAsset.getId(), secondTree);
            if (secondTreeAsset == null) continue;
            resultFiles.addAll(this.getDifferenceInChildFiles(firstTreeAsset, secondTreeAsset));
        }
        return resultFiles;
    }

    private List<Asset> getAssets(Asset root) {
        return root != null ? root.getAllAssets(false) : new ArrayList();
    }

    private List<File> getDifferenceInChildFiles(Asset firstAsset, Asset secondAsset) {
        ArrayList<File> resultFiles = new ArrayList<File>();
        List firstAssetFiles = firstAsset.getDirectDescendantFiles();
        List secondAssetFiles = secondAsset == null ? null : secondAsset.getDirectDescendantFiles();
        for (File firstAssetFile : firstAssetFiles) {
            File secondAssetFile = (File)this.findMatchingAsset(firstAssetFile.getId(), secondAssetFiles);
            boolean match = false;
            if (secondAssetFile != null) {
                String secondURL;
                String firstURL = firstAssetFile.getURL();
                boolean bl = match = firstURL == (secondURL = secondAssetFile.getURL()) || firstURL != null && firstURL.equals(secondURL);
            }
            if (match) continue;
            resultFiles.add(firstAssetFile);
        }
        return resultFiles;
    }

    private <T extends Asset> T findMatchingAsset(long assetID, Collection<T> assets) {
        if (assets != null) {
            for (Asset asset : assets) {
                if (asset.getId() != assetID) continue;
                return (T)asset;
            }
        }
        return null;
    }

    private void moveToUnmappedFilesDir(List<File> files, String dirName) {
        for (File file : files) {
            AssetsManager assetsManager;
            String url;
            Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
            if (urlField == null || (url = urlField.getValue()) == null || !this.fileExist(url) || !url.startsWith((assetsManager = AssetsManager.getThreadLocalInstance()).getMappedFilesDirectory())) continue;
            logger.debug((Object)("Attempting to move file [" + url + "] to unmapped files dircetory."));
            String movedFile = null;
            try {
                movedFile = assetsManager.moveToUnmappedFilesDirectory(url, dirName);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to move file [" + url + "] from mapped files directory to unmapped files directory [" + assetsManager.getUnmappedFilesDirectory() + "]. ", e);
            }
            logger.debug((Object)("Moved file [" + url + "] to [" + movedFile + "]"));
        }
    }

    private boolean fileExist(String path) {
        String parentPath = Paths.get(path, new String[0]).getParent().toString();
        try {
            List<String> paths = ContentServerUtil.listSubFilePaths(parentPath);
            return paths.contains(path);
        }
        catch (ContentServerException e) {
            logger.error((Object)("fail to list all the files in " + parentPath), (Throwable)e);
            return false;
        }
    }

    private void moveFilesToMappedFilesDir(Title title) {
        AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
        Asset asset = title.getAsset();
        List files = asset.getAllDescendantFiles();
        if (files != null) {
            for (File file : files) {
                String url;
                logger.debug((Object)("File: " + file));
                Field urlField = file.getFirstField(FieldName.FILE_URL.toString());
                if (urlField == null || (url = urlField.getValue()) == null || !url.startsWith(assetsManager.getUnmappedFilesDirectory())) continue;
                String movedFile = null;
                try {
                    logger.debug((Object)("Attempting to move file [" + url + "] to mapped files dircetory."));
                    movedFile = assetsManager.moveToMappedFilesDirectory(url);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to move file [" + url + "] from unmapped files directory to mapped files directory [" + assetsManager.getMappedFilesDirectory() + "]. ", e);
                }
                if (movedFile == null) continue;
                logger.debug((Object)("Moved file [" + url + "] to [" + movedFile + "]"));
                urlField.setValue(movedFile);
            }
        }
    }

    private void sendProgressStatusForManuallyMappedFiles(Map<File, Asset> fileToAssetMap, Title title, String sourceComponentName, String sourceEntityName, String sourceId) {
        for (File file : fileToAssetMap.keySet()) {
            Asset asset = fileToAssetMap.get(file);
            if (asset.getRoot() == null) {
                this.statusService.sendMetadataReceivedStatus(title, sourceComponentName, sourceEntityName, sourceId);
                continue;
            }
            String titleName = asset.getAssetType();
            this.statusService.sendAssetReceivedStatus(title, titleName, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private Map<File, Asset> getNewlyAddedFiles(Asset incomingAsset, Asset existingAsset) {
        HashMap<File, Asset> fileToAssetMap = new HashMap<File, Asset>();
        List<Asset> incomingTree = this.getAssets(incomingAsset);
        List<Asset> existingTree = this.getAssets(existingAsset);
        for (Asset incomingTreeAsset : incomingTree) {
            Asset existingTreeAsset = this.findMatchingAsset(incomingTreeAsset.getId(), existingTree);
            List<File> files = this.getDifferenceInChildFiles(incomingTreeAsset, existingTreeAsset);
            for (File file : files) {
                fileToAssetMap.put(file, incomingTreeAsset);
            }
        }
        return fileToAssetMap;
    }

    private void checkLicense(Long contentClassId) {
        LicenseManager.getInstance().canCreateMasterTitle(LicenseFilter.newBuilder().setContentClassId(contentClassId).build());
    }

    private static final class WorkflowNotifier
    extends Thread {
        private static final Logger logger = Logger.getLogger(WorkflowNotifier.class);
        private Long requestKey;
        private List<File> mappedFiles;

        WorkflowNotifier(Long requestKey, List<File> mappedFiles) {
            this.requestKey = requestKey;
            this.mappedFiles = mappedFiles;
        }

        @Override
        public void run() {
            try {
                WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"CM0109");
                WPCLCommand command = new WPCLCommand("task-complete");
                message.setCommand(command);
                MessageKeyImpl key = new MessageKeyImpl((Object)this.requestKey);
                message.setKey((IMessageKey)key);
                StringBuilder fileIds = new StringBuilder();
                for (File file : this.mappedFiles) {
                    if (fileIds.length() != 0) {
                        fileIds.append(",");
                    }
                    fileIds.append(file.getId());
                }
                message.putValue("fileAssetIds", (Object)fileIds);
                SoapRouter router = new SoapRouter();
                router.send(new WPCLConverter().convert(message));
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send task completion notification(CM0109) message, error: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }
}

