/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.core.ProgressEvent;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class ProgressManager {
    private static final Logger logger = Logger.getLogger(ProgressManager.class);
    private ITitleManager titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);

    ProgressManager() {
    }

    public static ProgressManager newInstance() {
        return new ProgressManager();
    }

    @Transactional
    public void updateStatus(long titleId, Long scheduleId, String status, String value, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        if (title == null) {
            throw new RuntimeException("Cannot set progress for titleId: " + titleId + " as title does not exist.");
        }
        this.updateStatus(title, scheduleId, status, value, success, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    public void updateStatus(Title title, Long scheduleId, String status, String value, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        ProgressItem newPI = new ProgressItem(status, value, title.getId().longValue(), title.getAsset().getVersion(), sourceComponentName, sourceEntityName, sourceId);
        newPI.setIsSuccess(Boolean.valueOf(success));
        newPI.setAssetListId(scheduleId);
        this.save(newPI);
    }

    private void save(ProgressItem pi) {
        Long titleId = pi.getTitleId();
        Long scheduleId = pi.getAssetListId();
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)pi);
        logger.debug((Object)("Updated progress item " + pi));
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ProgressEvent(this, scheduleId, (long)titleId, pi.getName()));
    }
}

