/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.metadataconfig;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.AppType;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.ContentAdvisory;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Genre;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Product;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Rating;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Studio;
import com.tandbergtv.watchpoint.pmm.metadataconfig.AppTypeOptionProvider;
import com.tandbergtv.watchpoint.pmm.metadataconfig.ContentAdvisoryOptionProvider;
import com.tandbergtv.watchpoint.pmm.metadataconfig.GenreOptionProvider;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurationReader;
import com.tandbergtv.watchpoint.pmm.metadataconfig.ProductOptionProvider;
import com.tandbergtv.watchpoint.pmm.metadataconfig.RatingOptionProvider;
import com.tandbergtv.watchpoint.pmm.metadataconfig.StudioOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.IVariableOptionProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class MetadataConfigurationReaderImpl
implements IMetadataConfigurationReader {
    private Map<String, IVariableOptionProvider> variableOptionProviders = new HashMap<String, IVariableOptionProvider>();

    public MetadataConfigurationReaderImpl() {
        this.variableOptionProviders.put(AppTypeOptionProvider.class.getName(), new AppTypeOptionProvider());
        this.variableOptionProviders.put(ContentAdvisoryOptionProvider.class.getName(), new ContentAdvisoryOptionProvider());
        this.variableOptionProviders.put(GenreOptionProvider.class.getName(), new GenreOptionProvider());
        this.variableOptionProviders.put(ProductOptionProvider.class.getName(), new ProductOptionProvider());
        this.variableOptionProviders.put(RatingOptionProvider.class.getName(), new RatingOptionProvider());
        this.variableOptionProviders.put(StudioOptionProvider.class.getName(), new StudioOptionProvider());
    }

    @Transactional
    public List<AppType> getAllAppTypes(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "a.appType " + asc;
        if ("Notes".equalsIgnoreCase(sortColumn)) {
            orderByStr = "a.notes " + asc + ", a.appType " + asc;
        }
        String query = "from AppType a order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    @Transactional
    public List<ContentAdvisory> getAllContentAdvisories(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "ca.contentAdvisory " + asc;
        if ("description".equalsIgnoreCase(sortColumn)) {
            orderByStr = "ca.description " + asc + ", ca.contentAdvisory " + asc;
        }
        String query = "from ContentAdvisory ca order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    @Transactional
    public List<Genre> getAllGenre(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "g.genre " + asc;
        if ("description".equalsIgnoreCase(sortColumn)) {
            orderByStr = "g.description " + asc + ", g.genre " + asc;
        }
        String query = "from Genre g order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    @Transactional
    public List<Product> getAllProducts(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "p.productCode " + asc;
        if ("description".equalsIgnoreCase(sortColumn)) {
            orderByStr = "p.description " + asc + ", p.productCode " + asc;
        }
        String query = "from Product p order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    @Transactional
    public List<Rating> getAllRatings(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "r.rating " + asc + ", r.ratingSystem " + asc;
        if ("description".equalsIgnoreCase(sortColumn)) {
            orderByStr = "r.description " + asc + ", r.rating " + asc + ", r.ratingSystem " + asc;
        } else if ("ratingSystem".equalsIgnoreCase(sortColumn)) {
            orderByStr = "r.ratingSystem " + asc + ", r.rating " + asc;
        }
        String query = "from Rating r order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    @Transactional
    public List<Studio> getAllStudios(String sortColumn, Boolean descending) {
        String asc = descending != false ? "desc" : "asc";
        String orderByStr = "s.displayName " + asc;
        if ("description".equalsIgnoreCase(sortColumn)) {
            orderByStr = "s.description " + asc + ", s.displayName " + asc;
        } else if ("organizationName".equalsIgnoreCase(sortColumn)) {
            orderByStr = "s.organizationName " + asc + ", s.displayName " + asc;
        } else if ("organizationCode".equalsIgnoreCase(sortColumn)) {
            orderByStr = "s.organizationCode " + asc + ", s.displayName " + asc;
        }
        String query = "from Studio s order by " + orderByStr;
        Session session = this.getSession();
        Query queryObject = session.createQuery(query);
        List results = queryObject.list();
        return results;
    }

    public IVariableOptionProvider getAppTypeOptionProvider() {
        return this.variableOptionProviders.get(AppTypeOptionProvider.class.getName());
    }

    public IVariableOptionProvider getContentAdvisoryOptionProvider() {
        return this.variableOptionProviders.get(ContentAdvisoryOptionProvider.class.getName());
    }

    public IVariableOptionProvider getGenreOptionProvider() {
        return this.variableOptionProviders.get(GenreOptionProvider.class.getName());
    }

    public IVariableOptionProvider getProductOptionProvider() {
        return this.variableOptionProviders.get(ProductOptionProvider.class.getName());
    }

    public IVariableOptionProvider getRatingOptionProvider() {
        return this.variableOptionProviders.get(RatingOptionProvider.class.getName());
    }

    public IVariableOptionProvider getStudioOptionProvider() {
        return this.variableOptionProviders.get(StudioOptionProvider.class.getName());
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public String getServiceName() {
        return "Metadata Configuration Reader";
    }

    public void start() {
    }

    public void stop() {
    }
}

