/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.dao;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateDAO;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.dao.PartnerSearchSqlMetadata;
import com.tandbergtv.watchpoint.pmm.util.ParterSearchCriteriaUtil;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PartnerHDAO
extends HibernateDAO<Partner, Long> {
    private static final Logger log = Logger.getLogger(PartnerHDAO.class);

    public PartnerHDAO(Class<Partner> persistentClass, Session session) {
        super(persistentClass, session);
    }

    public PartnerHDAO(Session session) {
        super(Partner.class, session);
    }

    private List<Partner> findPartnersByAffiliationCodePattern(String parentAffiliationCodePattern) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode like :code  order by p.affiliationCode");
        q.setParameter("code", (Object)parentAffiliationCodePattern);
        return q.list();
    }

    private List<Partner> findPartnersByAffiliationCodePatternAndName(String parentAffiliationCodePattern, String name, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode like :code and upper(p.name) like :name " + typeClause + "order by p.name");
        q.setParameter("code", (Object)parentAffiliationCodePattern);
        q.setParameter("name", (Object)("%" + name.toUpperCase() + "%"));
        return q.list();
    }

    private List<Partner> findPartnersWithoutAffiliationCodeByName(String name, PartnerType ... types) {
        String typeClause = "";
        if (types != null && types.length != 0) {
            typeClause = String.format(" and p.type IN ( %s )  ", StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
        }
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.affiliationCode is null and upper(p.name) like :name " + typeClause + "order by p.name");
        q.setParameter("name", (Object)("%" + name.toUpperCase() + "%"));
        return q.list();
    }

    public List<Partner> findAllChildPartners(String parentAffiliationCode) {
        return this.findPartnersByAffiliationCodePattern(parentAffiliationCode + "_%");
    }

    public List<Partner> findDirectChildPartners(String parentAffiliationCode) {
        StringBuilder sb = new StringBuilder(5);
        for (int i = 0; i < Partner.MIN_AFFILIATION_CODE_LEN; ++i) {
            sb.append("_");
        }
        String placeHolder = sb.toString();
        return this.findPartnersByAffiliationCodePattern(parentAffiliationCode + placeHolder);
    }

    public Partner findByName(String name) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.name = :name");
        q.setParameter("name", (Object)name);
        return (Partner)q.uniqueResult();
    }

    public Partner findByAffiliationCode(String affiliationCode) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.affiliationCode = :affiliationCode");
        q.setParameter("affiliationCode", (Object)affiliationCode);
        return (Partner)q.uniqueResult();
    }

    public Partner findByProviderId(String providerId) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.providerId = :providerId");
        q.setParameter("providerId", (Object)providerId);
        return (Partner)q.uniqueResult();
    }

    public Partner findByLookupKey(String lookupKey) {
        Query q = this.getSession().createQuery("FROM Partner p WHERE p.isActive = true and p.lookupKey = :lookupKey");
        q.setParameter("lookupKey", (Object)lookupKey);
        return (Partner)q.uniqueResult();
    }

    public PartnerSearchSqlMetadata composeSql(String userName, SearchCriteria searchCriteria, boolean isTopLevel, boolean fetchTopLevlForMatchedChildren, boolean inSpecifiedPartners, PartnerType ... types) {
        String typeClause = "";
        boolean specifyType = false;
        if (types != null && types.length != 0) {
            specifyType = true;
            typeClause = " and p.type IN (:type) ";
        }
        String searchPartnersClause = inSpecifiedPartners ? " and p.id in (:searchIds) " : "";
        String userClause = "";
        String topLevelClause = "";
        boolean specifyUserName = false;
        if (userName != null) {
            specifyUserName = true;
            String userClauseTemplate = " and p.id IN (SELECT pu.partnerId from PartnerUser pu WHERE %s pu.userName = :userName) ";
            String topLevelCondition = isTopLevel ? "(pu.inheritedFlag is null or pu.inheritedFlag is false) and " : "";
            userClause = String.format(userClauseTemplate, topLevelCondition);
        } else if (isTopLevel) {
            topLevelClause = String.format("and (length(p.affiliationCode) = %d or p.affiliationCode is null)", Partner.MIN_AFFILIATION_CODE_LEN);
        }
        String searchConditionClause = PartnerHDAO.createSearchConditionClause(searchCriteria, fetchTopLevlForMatchedChildren, inSpecifiedPartners);
        String orderByClause = this.generateOrderClause(searchCriteria);
        String sql = "FROM Partner p WHERE p.isActive = true " + userClause + searchConditionClause + topLevelClause + typeClause + searchPartnersClause + orderByClause;
        return new PartnerSearchSqlMetadata(sql, specifyUserName, specifyType, inSpecifiedPartners);
    }

    private String generateOrderClause(SearchCriteria searchCriteria) {
        if (searchCriteria == null) {
            return "";
        }
        StringBuilder orderByClause = new StringBuilder("order by ");
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            String orderProperty = param.getFieldName();
            if (param.getSortingOrder().equals((Object)SortingOrder.ASCENDING)) {
                orderByClause.append(orderProperty).append(" asc, p.id asc,");
                continue;
            }
            orderByClause.append(orderProperty).append(" desc, p.id desc,");
        }
        return orderByClause.append(String.format(" substring(p.affiliationCode, 1, %d) asc, length(p.affiliationCode) asc", Partner.MIN_AFFILIATION_CODE_LEN * 2)).toString();
    }

    public List<Partner> findActiveBySearchCriteria(String userName, SearchCriteria searchCriteria, boolean isTopLevel, boolean fetchTopLevlForMatchedChildren, List<Partner> searchPartners, boolean pageLimitation, PartnerType ... types) {
        boolean inSpecifiedPartners = !CollectionUtils.isEmpty(searchPartners);
        PartnerSearchSqlMetadata sqlMetadata = this.composeSql(userName, searchCriteria, isTopLevel, fetchTopLevlForMatchedChildren, inSpecifiedPartners, types);
        Query q = this.setQueryParameter(sqlMetadata, searchCriteria, userName, searchPartners, types);
        log.info((Object)("get partners sql: " + q.getQueryString()));
        if (pageLimitation) {
            this.setPageLimitation(searchCriteria, q);
        }
        List activeList = q.list();
        log.info((Object)("Found the Partners (" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    private void setPageLimitation(SearchCriteria searchCriteria, Query q) {
        if (searchCriteria != null) {
            log.debug((Object)("staring record num: " + searchCriteria.getStartingRecordNumber() + "\n\n"));
            q.setFirstResult(searchCriteria.getStartingRecordNumber());
            if (searchCriteria.getRecordsCount() > 0) {
                q.setMaxResults(searchCriteria.getRecordsCount());
            }
        }
    }

    private Query setQueryParameter(PartnerSearchSqlMetadata sqlMetadata, SearchCriteria searchCriteria, String userName, List<Partner> searchPartners, PartnerType ... types) {
        Query q = this.getSession().createQuery(sqlMetadata.getSql());
        q.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (sqlMetadata.isSpecifyType()) {
            q.setParameterList("type", Arrays.asList(types));
        }
        if (sqlMetadata.isSpecifyUserName()) {
            q.setParameter("userName", (Object)userName);
        }
        if (sqlMetadata.isSpecifyPartnerIds()) {
            List ids = searchPartners.stream().map(Partner::getId).collect(Collectors.toList());
            q.setParameterList("searchIds", ids);
        }
        if (ParterSearchCriteriaUtil.hasBasicSearchCriteria(searchCriteria)) {
            this.setSearchParameter(q, searchCriteria);
        }
        return q;
    }

    private void setSearchParameter(Query q, SearchCriteria searchCriteria) {
        searchCriteria.getSearchList().stream().filter(p -> p instanceof ValueParameter).forEach(p -> {
            ValueParameter param = (ValueParameter)p;
            String field = param.getFieldName();
            String value = (String)param.getValue();
            SearchOperator operator = param.getOperator();
            if (operator == SearchOperator.EQUAL) {
                q.setParameter(field, (Object)PartnerHDAO.escapeSqlSpecialChars(value));
            } else if (operator == SearchOperator.LIKE) {
                q.setParameter(field, (Object)("%" + PartnerHDAO.escapeSqlSpecialChars(value) + "%"));
            }
        });
    }

    private static String createSearchConditionClause(SearchCriteria searchCriteria, boolean fetchTopLevlForMatchedChildren, boolean specifyParentParnterIds) {
        if (!ParterSearchCriteriaUtil.hasBasicSearchCriteria(searchCriteria)) {
            return "";
        }
        String childPartnerCondition = PartnerHDAO.generateBasicSearchConditionClause(searchCriteria, "cp");
        if (specifyParentParnterIds) {
            return String.format(" and exists(select 1 from Partner cp where cp.isActive=true and cp.affiliationCode like (p.affiliationCode ||'_%%') and %s) ", childPartnerCondition);
        }
        String toppartnerCondition = PartnerHDAO.generateBasicSearchConditionClause(searchCriteria, "p");
        if (fetchTopLevlForMatchedChildren) {
            return String.format(" and (%s or exists(select 1 from Partner cp where cp.isActive=true and cp.affiliationCode like (p.affiliationCode ||'_%%') and %s )) ", toppartnerCondition, childPartnerCondition);
        }
        return String.format(" and %s ", toppartnerCondition);
    }

    private static String generateBasicSearchConditionClause(SearchCriteria sc, String table) {
        if (sc == null) {
            return "";
        }
        ArrayList clauses = new ArrayList();
        sc.getSearchList().stream().filter(p -> p instanceof ValueParameter).forEach(param -> {
            ValueParameter p = (ValueParameter)param;
            SearchOperator operator = p.getOperator();
            String field = p.getFieldName();
            switch (operator) {
                case EQUAL: {
                    clauses.add(String.format(" cast(%s.%s as string) = :%s ", table, field, field));
                    break;
                }
                case LIKE: {
                    clauses.add(String.format(" lower(%s.%s) like lower(:%s) escape '\\' ", table, field, field));
                    break;
                }
            }
        });
        return String.join((CharSequence)" and ", clauses);
    }

    public static String escapeSqlSpecialChars(String str) {
        return str.replace("_", "\\_").replace("%", "\\%");
    }

    public int findTopLevelCountActiveBySearchCriteria(String userName, SearchCriteria searchCriteria, PartnerType ... types) {
        PartnerSearchSqlMetadata sqlMetadata = this.composeSql(userName, searchCriteria, true, true, false, types);
        Query q = this.setQueryParameter(sqlMetadata, searchCriteria, userName, null, types);
        log.info((Object)("get partners count sql: " + q.getQueryString()));
        int count = q.list().size();
        log.info((Object)("Found the Partners (" + count + ") for the given Search Criteria."));
        return count;
    }

    private List<Integer> getTypeIdList(PartnerType ... types) {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        for (PartnerType type : types) {
            typeIds.add(type.getTypeId());
        }
        return typeIds;
    }

    public List<Partner> findByActive(boolean isActive) {
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)isActive)});
        return this.findByCriteria(criteria);
    }

    public List<Partner> findPartnersWithChildPartnersLevel(String parentAffiliationCode, int level) {
        StringBuilder sb = new StringBuilder(20);
        int len = level * Partner.MIN_AFFILIATION_CODE_LEN;
        for (int i = 0; i < len; ++i) {
            sb.append("_");
        }
        String placeHolder = sb.toString();
        return this.findPartnersByAffiliationCodePattern(parentAffiliationCode + placeHolder);
    }

    public List<Partner> findTopLevelPartnersByName(String name) {
        StringBuilder sb = new StringBuilder(5);
        for (int i = 0; i < Partner.MIN_AFFILIATION_CODE_LEN; ++i) {
            sb.append("_");
        }
        String placeHolder = sb.toString();
        List<Partner> allTopPartners = this.findPartnersByAffiliationCodePatternAndName(placeHolder, name, PartnerType.SOURCE);
        allTopPartners.addAll(this.findPartnersWithoutAffiliationCodeByName(name, PartnerType.SOURCE));
        return allTopPartners;
    }
}

